/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.test;

import java.util.List;
import java.util.Properties;
import javax.batch.operations.NoSuchJobException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.test.SynchronousJobOperator;

public class JobLauncher {
    private static final SynchronousJobOperator SYNCHRONOUS_JOB_OPERATOR = new SynchronousJobOperator();
    private final String name;

    public JobLauncher(String name) {
        this.name = name;
    }

    public JobExecution start(Properties properties) {
        long id = SYNCHRONOUS_JOB_OPERATOR.start(this.name, properties);
        return SYNCHRONOUS_JOB_OPERATOR.getJobExecution(id);
    }

    public List<StepExecution> getLastStepExecutions() {
        List<JobInstance> instance;
        int jobInstanceCount = SYNCHRONOUS_JOB_OPERATOR.getJobInstanceCount(this.name);
        try {
            instance = SYNCHRONOUS_JOB_OPERATOR.getJobInstances(this.name, jobInstanceCount, 1);
        }
        catch (NoSuchJobException nsje) {
            instance = SYNCHRONOUS_JOB_OPERATOR.getJobInstances(this.name, jobInstanceCount - 1, 1);
        }
        return SYNCHRONOUS_JOB_OPERATOR.getStepExecutions(instance.iterator().next().getInstanceId());
    }

    public static JobExecution start(String name, Properties properties) {
        long id = SYNCHRONOUS_JOB_OPERATOR.start(name, properties);
        return SYNCHRONOUS_JOB_OPERATOR.getJobExecution(id);
    }

    public JobExecution restart(long id, Properties properties) {
        long newId = SYNCHRONOUS_JOB_OPERATOR.restart(id, properties);
        return SYNCHRONOUS_JOB_OPERATOR.getJobExecution(newId);
    }
}

