/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleRestController {
    public static final String REST_CONTENT_TYPE = "text/plain";
    public static final String OP_START = "start/";
    public static final String OP_STATUS = "status/";
    public static final String OP_STOP = "stop/";
    public static final String OP_RESTART = "restart/";
    public static final long NO_JOB_ID = -1L;
    private final JobOperator jobOperator;

    public SimpleRestController(JobOperator jobOperator) {
        this.jobOperator = jobOperator;
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse resp, String path) {
        resp.setContentType(REST_CONTENT_TYPE);
        if (path != null && path.startsWith(OP_START)) {
            this.startBatch(path.substring(OP_START.length()), req, resp);
        } else if (path != null && path.startsWith(OP_STATUS)) {
            this.batchStatus(path.substring(OP_STATUS.length()), req, resp);
        } else if (path != null && path.startsWith(OP_STOP)) {
            this.batchStop(path.substring(OP_STOP.length()), req, resp);
        } else if (path != null && path.startsWith(OP_RESTART)) {
            this.batchRestart(path.substring(OP_RESTART.length()), req, resp);
        } else {
            this.unknownCommand(path, resp);
        }
    }

    private void startBatch(String batchName, HttpServletRequest req, HttpServletResponse resp) {
        Properties jobProperties = this.extractJobProperties(req, resp);
        if (jobProperties == null) {
            return;
        }
        try {
            long jobId = this.jobOperator.start(batchName, jobProperties);
            this.reportSuccess(jobId, resp, null);
        }
        catch (JobStartException jobStartException) {
            StringBuilder msg = new StringBuilder("Error while starting job ");
            msg.append(batchName).append('\n');
            this.appendExceptionMsg(msg, (Exception)((Object)jobStartException));
            this.reportFailure(-1L, resp, msg.toString());
        }
    }

    private void batchStatus(String batchId, HttpServletRequest req, HttpServletResponse resp) {
        Long executionId = this.extractExecutionId(batchId, resp);
        if (executionId == null) {
            return;
        }
        try {
            JobExecution jobExecution = this.jobOperator.getJobExecution(executionId.longValue());
            BatchStatus batchStatus = jobExecution.getBatchStatus();
            this.reportSuccess(executionId, resp, batchStatus.name());
        }
        catch (NoSuchJobExecutionException noSuchJob) {
            this.reportFailure(executionId, resp, "NoSuchJob");
        }
        catch (Exception generalException) {
            StringBuilder msg = new StringBuilder("Failure in BatchExecution");
            this.appendExceptionMsg(msg, generalException);
            this.reportFailure(executionId, resp, msg.toString());
        }
    }

    private void batchStop(String batchId, HttpServletRequest req, HttpServletResponse resp) {
        Long executionId = this.extractExecutionId(batchId, resp);
        if (executionId == null) {
            return;
        }
        try {
            this.jobOperator.stop(executionId.longValue());
            this.reportSuccess(executionId, resp, BatchStatus.STOPPING.toString());
        }
        catch (NoSuchJobExecutionException noSuchJob) {
            this.reportFailure(executionId, resp, "NoSuchJob");
        }
        catch (JobExecutionNotRunningException notRunningException) {
            this.reportFailure(executionId, resp, "JobExecutionNotRunning");
        }
        catch (Exception generalException) {
            StringBuilder msg = new StringBuilder("Failure in BatchExecution");
            this.appendExceptionMsg(msg, generalException);
            this.reportFailure(executionId, resp, msg.toString());
        }
    }

    private void batchRestart(String batchId, HttpServletRequest req, HttpServletResponse resp) {
        Long executionId = this.extractExecutionId(batchId, resp);
        if (executionId == null) {
            return;
        }
        Properties jobProperties = this.extractJobProperties(req, resp);
        try {
            this.jobOperator.restart(executionId.longValue(), jobProperties);
        }
        catch (NoSuchJobExecutionException noSuchJob) {
            this.reportFailure(executionId, resp, "NoSuchJob");
        }
        catch (JobExecutionAlreadyCompleteException alreadyCompleted) {
            this.reportFailure(executionId, resp, "NoSuchJob");
        }
        catch (Exception generalException) {
            StringBuilder msg = new StringBuilder("Failure in BatchExecution");
            this.appendExceptionMsg(msg, generalException);
            this.reportFailure(executionId, resp, msg.toString());
        }
    }

    private void unknownCommand(String path, HttpServletResponse resp) {
        StringBuilder msg = new StringBuilder("Unknown command:");
        msg.append(path).append('\n');
        msg.append("The returned response if of MIME type text/plain and contains the following information\n");
        msg.append("  {jobExecutionId} (or -1 if no executionId was detected)\\n\n");
        msg.append("  OK (or FAILURE)\\n\n");
        msg.append("  followed by command specific information\n");
        msg.append("\nKnown commands are:\n\n");
        msg.append("* ").append(OP_START).append(" - start a new batch job\n");
        msg.append("  Sample: http://localhost:8080/myapp/jbatch/rest/start/myjobname?param1=x&param2=y\n");
        msg.append("  BatchEE will start the job and immediately return\n\n");
        msg.append("* ").append(OP_STATUS).append(" - query the current status \n");
        msg.append("  Sample: http://localhost:8080/myapp/jbatch/rest/status/23\n");
        msg.append("  will return the state of executionId 23\n\n");
        msg.append("* ").append(OP_STOP).append(" - stop the job with the given executionId \n");
        msg.append("  Sample: http://localhost:8080/myapp/jbatch/rest/stop/23\n");
        msg.append("  will stop the job with executionId 23\n\n");
        msg.append("* ").append(OP_RESTART).append(" - restart the job with the given executionId \n");
        msg.append("  Sample: http://localhost:8080/myapp/jbatch/rest/restart/23\n");
        msg.append("  will restart the job with executionId 23\n\n");
        this.reportFailure(-1L, resp, msg.toString());
    }

    private Properties extractJobProperties(HttpServletRequest req, HttpServletResponse resp) {
        Properties jobProperties = new Properties();
        Map parameterMap = req.getParameterMap();
        for (Map.Entry paramEntry : parameterMap.entrySet()) {
            String key = (String)paramEntry.getKey();
            if (key == null || key.length() == 0) {
                this.reportFailure(-1L, resp, "Parameter key must be set");
                return null;
            }
            String[] vals = (String[])paramEntry.getValue();
            if (vals == null || vals.length != 1) {
                this.reportFailure(-1L, resp, "Exactly one value must be set for each parameter (parameter name=" + key + ")");
                return null;
            }
            String val = vals[0];
            jobProperties.put(key, val);
        }
        return jobProperties;
    }

    private Long extractExecutionId(String batchId, HttpServletResponse resp) {
        if (batchId == null || batchId.isEmpty()) {
            this.reportFailure(-1L, resp, "no executionId given");
            return null;
        }
        try {
            return Long.valueOf(batchId);
        }
        catch (NumberFormatException nfe) {
            this.reportFailure(-1L, resp, "executionId must be numeric, but is " + batchId);
            return null;
        }
    }

    private void reportSuccess(long jobId, HttpServletResponse resp, String msg) {
        resp.setStatus(200);
        this.writeContent(resp, Long.toString(jobId) + "\n");
        this.writeContent(resp, "OK\n");
        if (msg != null) {
            this.writeContent(resp, msg);
        }
    }

    private void reportFailure(long jobId, HttpServletResponse resp, String content) {
        resp.setStatus(500);
        this.writeContent(resp, Long.toString(jobId) + "\n");
        this.writeContent(resp, "FAILURE\n");
        this.writeContent(resp, content);
    }

    private void writeContent(HttpServletResponse resp, String content) {
        try {
            resp.getWriter().append(content);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void appendExceptionMsg(StringBuilder msg, Exception exception) {
        msg.append(exception.getMessage()).append('\n');
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        msg.append(sw.toString());
    }
}

