/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobInstance;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JBatchController
extends HttpServlet {
    private static final String DEFAULT_MAPPING_SERVLET25 = "/jbatch";
    private static final int DEFAULT_PAGE_SIZE = 30;
    public static final String FORM_JOB_NAME = "___batchee_job_name___";
    private static final String EXECUTIONS_MAPPING = "/executions/";
    private static final String STEP_EXECUTIONS_MAPPING = "/step-executions/";
    private static final String START_MAPPING = "/start/";
    private static final String DO_START_MAPPING = "/doStart/";
    private static final String VIEW_MAPPING = "/view/";
    private JobOperator operator;
    private String context;
    private String mapping = "/jbatch";
    private int executionByPage = 30;
    private boolean readOnly = false;

    public JBatchController mapping(String rawMapping) {
        this.mapping = rawMapping.substring(0, rawMapping.length() - 2);
        return this;
    }

    public JBatchController executionByPage(int byPage) {
        this.executionByPage = byPage;
        return this;
    }

    public JBatchController readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public void init(ServletConfig config) throws ServletException {
        this.operator = BatchRuntime.getJobOperator();
        this.context = config.getServletContext().getContextPath();
        if ("/".equals(this.context)) {
            this.context = "";
        }
        this.mapping = this.context + this.mapping;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        req.setAttribute("context", (Object)this.context);
        req.setAttribute("mapping", (Object)this.mapping);
        String path = req.getPathInfo();
        if (path != null && path.startsWith(EXECUTIONS_MAPPING)) {
            String name = URLDecoder.decode(path.substring(EXECUTIONS_MAPPING.length()), "UTF-8");
            int start = JBatchController.extractInt(req, "start", -1);
            this.listExecutions(req, name, this.executionByPage, start);
        } else if (path != null && path.startsWith(STEP_EXECUTIONS_MAPPING)) {
            int executionId = Integer.parseInt(path.substring(STEP_EXECUTIONS_MAPPING.length()));
            this.listStepExecutions(req, executionId);
        } else if (path != null && path.startsWith(VIEW_MAPPING)) {
            String name = URLDecoder.decode(path.substring(VIEW_MAPPING.length()), "UTF-8");
            this.view(req, name);
        } else if (path != null && path.startsWith(START_MAPPING)) {
            if (this.readOnly) {
                this.reportReadOnly(req);
            } else {
                String name = URLDecoder.decode(path.substring(START_MAPPING.length()), "UTF-8");
                this.start(req, name);
            }
        } else if (path != null && path.startsWith(DO_START_MAPPING)) {
            if (this.readOnly) {
                this.reportReadOnly(req);
            } else {
                String name = URLDecoder.decode(path.substring(DO_START_MAPPING.length()), "UTF-8");
                if (name.isEmpty()) {
                    name = req.getParameter(FORM_JOB_NAME);
                }
                this.doStart(req, name, JBatchController.readProperties(req));
            }
        } else {
            this.listJobs(req);
        }
        req.getRequestDispatcher("/internal/batchee/layout.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void reportReadOnly(HttpServletRequest req) {
        req.setAttribute("view", (Object)"read-only");
    }

    private void view(HttpServletRequest req, String name) {
        req.setAttribute("name", (Object)name);
        req.setAttribute("view", (Object)"view");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String relativePath = "META-INF/batch-jobs/" + name + ".xml";
        InputStream stream = tccl.getResourceAsStream(relativePath);
        if (stream == null) {
            throw new BatchRuntimeException((Throwable)new FileNotFoundException("Cannot find an XML for " + name));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int r;
            while ((r = stream.read()) != -1) {
                baos.write(r);
            }
        }
        catch (IOException e) {
            throw new BatchRuntimeException((Throwable)new FileNotFoundException("Cannot find an XML for " + name));
        }
        req.setAttribute("content", (Object)new String(baos.toByteArray()).replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
    }

    private void doStart(HttpServletRequest req, String name, Properties properties) {
        req.setAttribute("id", (Object)this.operator.start(name, properties));
        req.setAttribute("name", (Object)name);
        req.setAttribute("view", (Object)"after-start");
    }

    private void start(HttpServletRequest req, String name) {
        req.setAttribute("view", (Object)"start");
        req.setAttribute("name", (Object)name);
    }

    private void listStepExecutions(HttpServletRequest req, int executionId) {
        List steps = this.operator.getStepExecutions((long)executionId);
        req.setAttribute("view", (Object)"step-executions");
        req.setAttribute("steps", (Object)steps);
        req.setAttribute("executionId", (Object)executionId);
        req.setAttribute("name", (Object)this.operator.getJobExecution((long)executionId).getJobName());
    }

    private void listExecutions(HttpServletRequest req, String name, int pageSize, int inStart) {
        if (!this.readOnly) {
            String stopId = req.getParameter("stop");
            if (stopId != null) {
                try {
                    this.operator.stop(Long.parseLong(stopId));
                }
                catch (NoSuchJobExecutionException nsje) {
                }
                catch (JobExecutionNotRunningException nsje) {}
            }
        } else {
            this.reportReadOnly(req);
            return;
        }
        int jobInstanceCount = this.operator.getJobInstanceCount(name);
        int start = inStart;
        if (start == -1) {
            start = Math.max(0, jobInstanceCount - pageSize);
        }
        ArrayList instances = new ArrayList(this.operator.getJobInstances(name, start, pageSize));
        Collections.sort(instances, JobInstanceIdComparator.INSTANCE);
        LinkedHashMap<JobInstance, List> executions = new LinkedHashMap<JobInstance, List>();
        for (JobInstance instance : instances) {
            executions.put(instance, this.operator.getJobExecutions(instance));
        }
        req.setAttribute("view", (Object)"job-instances");
        req.setAttribute("name", (Object)name);
        req.setAttribute("executions", executions);
        int nextStart = start + pageSize;
        if (nextStart > jobInstanceCount) {
            nextStart = -1;
        }
        req.setAttribute("nextStart", (Object)nextStart);
        req.setAttribute("previousStart", (Object)(start - pageSize));
        if (jobInstanceCount > pageSize) {
            req.setAttribute("lastStart", (Object)Math.max(0, jobInstanceCount - pageSize));
        } else {
            req.setAttribute("lastStart", (Object)-1);
        }
    }

    private void listJobs(HttpServletRequest req) throws ServletException, IOException {
        Set names = this.operator.getJobNames();
        if (names == null) {
            names = Collections.emptySet();
        }
        req.setAttribute("view", (Object)"jobs");
        req.setAttribute("names", names);
    }

    private static int extractInt(HttpServletRequest req, String name, int defaultValue) {
        String string = req.getParameter(name);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return defaultValue;
    }

    private static Properties readProperties(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (FORM_JOB_NAME.equals(key)) continue;
            map.put(key, req.getParameter(key));
        }
        Properties properties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("k_")) continue;
            String name = key.substring("k_".length());
            properties.setProperty(name, (String)map.get("v_" + name));
        }
        return properties;
    }

    private static class JobInstanceIdComparator
    implements Comparator<JobInstance> {
        private static final JobInstanceIdComparator INSTANCE = new JobInstanceIdComparator();

        private JobInstanceIdComparator() {
        }

        @Override
        public int compare(JobInstance o1, JobInstance o2) {
            return (int)(o2.getInstanceId() - o1.getInstanceId());
        }
    }
}

