/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.modelmapper;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.inject.Inject;
import java.util.Locale;
import org.apache.batchee.doc.api.Documentation;
import org.modelmapper.ModelMapper;
import org.modelmapper.config.Configuration;
import org.modelmapper.convention.MatchingStrategies;
import org.modelmapper.spi.MatchingStrategy;

@Documentation(value="uses model mapper to process the item")
public class ModelMapperItemProcessor
implements ItemProcessor {
    private volatile ModelMapper mapper = null;
    @Inject
    @BatchProperty
    @Documentation(value="matching strategy to use (LOOSE, STANDARD, STRICT or custom implementation)")
    private String matchingStrategy;
    @Inject
    @BatchProperty
    @Documentation(value="target type")
    private String destinationType;
    private volatile Class<?> destinationTypeClass = null;

    public Object processItem(Object o) throws Exception {
        this.loadClass();
        return this.ensureMapper().map(o, this.destinationTypeClass);
    }

    protected ModelMapper newMapper() {
        return new ModelMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClass() {
        if (this.destinationTypeClass == null) {
            if (this.destinationType == null) {
                throw new IllegalArgumentException("Please set destinationType");
            }
            ModelMapperItemProcessor modelMapperItemProcessor = this;
            synchronized (modelMapperItemProcessor) {
                if (this.destinationTypeClass == null) {
                    try {
                        ClassLoader loader = ModelMapperItemProcessor.currentLoader();
                        this.destinationTypeClass = loader.loadClass(this.destinationType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Can't load: '" + this.destinationType + "'", e);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new IllegalArgumentException("Can't load: '" + this.destinationType + "'", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelMapper ensureMapper() {
        if (this.mapper == null) {
            ModelMapperItemProcessor modelMapperItemProcessor = this;
            synchronized (modelMapperItemProcessor) {
                if (this.mapper == null) {
                    this.mapper = this.newMapper();
                    if (this.matchingStrategy != null) {
                        Configuration configuration = this.mapper.getConfiguration();
                        try {
                            configuration.setMatchingStrategy((MatchingStrategy)MatchingStrategy.class.cast(MatchingStrategies.class.getDeclaredField(this.matchingStrategy.toUpperCase(Locale.ENGLISH)).get(null)));
                        }
                        catch (Exception e) {
                            try {
                                configuration.setMatchingStrategy((MatchingStrategy)MatchingStrategy.class.cast(ModelMapperItemProcessor.currentLoader().loadClass(this.matchingStrategy)));
                            }
                            catch (Exception e1) {
                                if (RuntimeException.class.isInstance(e)) {
                                    throw (RuntimeException)RuntimeException.class.cast(e);
                                }
                                throw new IllegalStateException(e);
                            }
                        }
                    }
                }
            }
        }
        return this.mapper;
    }

    private static ClassLoader currentLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ModelMapperItemProcessor.class.getClassLoader();
        }
        return loader;
    }
}

