/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.maven;

import java.util.List;
import java.util.Locale;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.tools.maven.BatchEEMojoBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="step-executions")
public class StepExecutionsMojo
extends BatchEEMojoBase {
    @Parameter(required=true, property="batchee.executionId")
    protected long executionId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List executions = this.getOrCreateOperator().getStepExecutions(this.executionId);
        this.getLog().info((CharSequence)("Step executions for job execution #" + this.executionId + ":"));
        for (StepExecution exec : executions) {
            this.getLog().info((CharSequence)(" - id = " + exec.getStepExecutionId()));
            this.getLog().info((CharSequence)("   + step = " + exec.getStepName()));
            this.getLog().info((CharSequence)("   + batch status = " + exec.getBatchStatus()));
            this.getLog().info((CharSequence)("   + exit status = " + exec.getExitStatus()));
            this.getLog().info((CharSequence)("   + start time = " + exec.getStartTime()));
            this.getLog().info((CharSequence)("   + end time = " + exec.getEndTime()));
            this.getLog().info((CharSequence)"   + metrics");
            if (exec.getMetrics() == null) continue;
            for (Metric m : exec.getMetrics()) {
                this.getLog().info((CharSequence)("     > " + m.getType().name().replace("COUNT", "").replace("_", " ").toLowerCase(Locale.ENGLISH) + " = " + m.getValue()));
            }
        }
    }
}

