/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsonp;

import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;

public class JsonPartialReader {
    private final JsonParser parser;
    private final JsonProvider provider;
    private boolean closed = false;

    public JsonPartialReader(JsonProvider provider, JsonParser parser) {
        this.parser = parser;
        this.provider = provider == null ? JsonProvider.provider() : provider;
    }

    public JsonStructure read(JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: {
                JsonObjectBuilder objectBuilder = this.provider.createObjectBuilder();
                this.parseObject(objectBuilder);
                return objectBuilder.build();
            }
            case START_ARRAY: {
                JsonArrayBuilder arrayBuilder = this.provider.createArrayBuilder();
                this.parseArray(arrayBuilder);
                return arrayBuilder.build();
            }
        }
        throw new JsonParsingException("Unknown structure: " + this.parser.next(), this.parser.getLocation());
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parser.close();
        }
    }

    private void parseObject(JsonObjectBuilder builder) {
        String key = null;
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block12;
                }
                case VALUE_STRING: {
                    builder.add(key, this.parser.getString());
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilder subObject = this.provider.createObjectBuilder();
                    this.parseObject(subObject);
                    builder.add(key, subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilder subArray = this.provider.createArrayBuilder();
                    this.parseArray(subArray);
                    builder.add(key, subArray);
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        builder.add(key, this.parser.getLong());
                        continue block12;
                    }
                    builder.add(key, this.parser.getBigDecimal());
                    continue block12;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block12;
                }
                case END_OBJECT: {
                    return;
                }
                case END_ARRAY: {
                    throw new JsonParsingException("']', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void parseArray(JsonArrayBuilder builder) {
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case VALUE_STRING: {
                    builder.add(this.parser.getString());
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        builder.add(this.parser.getLong());
                        continue block12;
                    }
                    builder.add(this.parser.getBigDecimal());
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilder subObject = this.provider.createObjectBuilder();
                    this.parseObject(subObject);
                    builder.add(subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilder subArray = this.provider.createArrayBuilder();
                    this.parseArray(subArray);
                    builder.add(subArray);
                    continue block12;
                }
                case END_ARRAY: {
                    return;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block12;
                }
                case KEY_NAME: {
                    throw new JsonParsingException("array doesn't have keys", this.parser.getLocation());
                }
                case END_OBJECT: {
                    throw new JsonParsingException("'}', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }
}

