/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsonp;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonParser;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.CountedReader;
import org.apache.batchee.jsonp.JsonPartialReader;

@Documentation(value="Reads a JSON file using JSON-P providing JsonStructure as item.")
public class JsonpReader
extends CountedReader {
    @Inject
    @BatchProperty
    @Documentation(value="Incoming file")
    private String file;
    @Inject
    @BatchProperty
    @Documentation(value="Should root be skipped (default: true)")
    private String skipRoot;
    @Inject
    @BatchProperty
    @Documentation(value="JSON-P provider if not using the default")
    private String provider;
    private JsonParser parser;
    private JsonPartialReader reader;
    private JsonParser.Event end = null;

    public void open(Serializable checkpoint) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        JsonProvider provider = this.provider == null ? JsonProvider.provider() : (JsonProvider)JsonProvider.class.cast(loader.loadClass(this.provider));
        this.parser = provider.createParser((InputStream)new FileInputStream(this.file));
        this.reader = new JsonPartialReader(provider, this.parser);
        if (this.skipRoot == null || "true".equalsIgnoreCase(this.skipRoot)) {
            JsonParser.Event event = this.parser.next();
            this.end = event == JsonParser.Event.START_ARRAY ? JsonParser.Event.END_ARRAY : JsonParser.Event.END_OBJECT;
        }
        super.open(checkpoint);
    }

    protected Object doRead() throws Exception {
        JsonParser.Event event;
        while ((event = this.parser.next()) != JsonParser.Event.START_OBJECT && event != this.end || this.end == null && (event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT)) {
        }
        if (!this.parser.hasNext()) {
            return null;
        }
        return this.reader.read(event);
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

