/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.jsefa.csv.annotation.CsvDataType;
import net.sf.jsefa.csv.annotation.CsvField;
import org.apache.batchee.jsefa.Header;

public class JSefaCsvMapping {
    private final List<String> headers = new ArrayList<String>();

    private JSefaCsvMapping(Class<?> type) {
        this.calculateHeaders(type);
    }

    public Iterable<String> getHeader() {
        return this.headers;
    }

    private void calculateHeaders(Class<?> type) {
        TreeMap<Integer, SortedMap<Integer, String>> allHeaders = new TreeMap<Integer, SortedMap<Integer, String>>();
        this.calculateHeaders(type, allHeaders, 0);
        for (SortedMap headerMap : allHeaders.values()) {
            for (String header : headerMap.values()) {
                this.headers.add(header);
            }
        }
    }

    private void calculateHeaders(Class<?> type, SortedMap<Integer, SortedMap<Integer, String>> allHeaders, int index) {
        if (type.getSuperclass() != Object.class) {
            this.calculateHeaders(type.getSuperclass(), allHeaders, index - 1);
        }
        TreeMap<Integer, String> typeHeaders = new TreeMap<Integer, String>();
        for (Field field : type.getDeclaredFields()) {
            String previousField;
            CsvField fieldAnnotation = field.getAnnotation(CsvField.class);
            if (fieldAnnotation == null) continue;
            if (field.getType().getAnnotation(CsvDataType.class) != null) {
                this.calculateHeaders(field.getType(), allHeaders, fieldAnnotation.pos());
                continue;
            }
            String header = null;
            Header headerAnnotation = field.getAnnotation(Header.class);
            if (headerAnnotation != null) {
                header = headerAnnotation.value();
            }
            if (header == null || header.isEmpty()) {
                header = field.getName();
            }
            if ((previousField = typeHeaders.put(fieldAnnotation.pos(), header)) == null) continue;
            throw new IllegalArgumentException(String.format("multiple fields for position %d defined! Fields: %s! Type: %s", fieldAnnotation.pos(), previousField + ", " + field.getName(), type.getName()));
        }
        allHeaders.put(index, typeHeaders);
    }

    public static List<JSefaCsvMapping> forTypes(Class<?> ... types) {
        ArrayList<JSefaCsvMapping> mappings = new ArrayList<JSefaCsvMapping>(types.length);
        for (Class<?> type : types) {
            mappings.add(new JSefaCsvMapping(type));
        }
        return mappings;
    }
}

