/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import net.sf.jsefa.common.accessor.ObjectAccessorProvider;
import net.sf.jsefa.common.config.Configuration;
import net.sf.jsefa.common.config.ValidationMode;
import net.sf.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import net.sf.jsefa.common.lowlevel.filter.LineFilter;
import net.sf.jsefa.common.mapping.EntryPoint;
import net.sf.jsefa.common.mapping.TypeMappingRegistry;
import net.sf.jsefa.common.validator.provider.ValidatorProvider;
import net.sf.jsefa.csv.config.CsvConfiguration;
import net.sf.jsefa.csv.lowlevel.config.EscapeMode;
import net.sf.jsefa.csv.lowlevel.config.QuoteMode;
import net.sf.jsefa.flr.config.FlrConfiguration;
import net.sf.jsefa.rbf.config.RbfConfiguration;
import net.sf.jsefa.rbf.lowlevel.config.RbfLowLevelConfiguration;
import net.sf.jsefa.xml.config.XmlConfiguration;
import net.sf.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import net.sf.jsefa.xml.mapping.support.XmlDataTypeDefaultNameRegistry;
import net.sf.jsefa.xml.namespace.NamespaceManager;
import net.sf.jsefa.xml.namespace.QName;
import org.apache.batchee.extras.lang.Langs;

public class JsefaConfigurations {
    public static Class<?>[] createObjectTypes(String objectTypes) throws ClassNotFoundException {
        if (objectTypes == null) {
            throw new NullPointerException("objectTypes shouldn't be null");
        }
        String[] types = objectTypes.split(",");
        Class[] classes = new Class[types.length];
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < types.length; ++i) {
            classes[i] = loader.loadClass(types[i]);
        }
        return classes;
    }

    public static <A extends TypeMappingRegistry<?>, B extends EntryPoint<?, ?>> void setConfiguration(Configuration<A, B> configuration, String validationMode, String validationProvider, String objectAccessorProvider, String simpleTypeProvider, String typeMappingRegistry) throws Exception {
        if (validationMode != null) {
            configuration.setValidationMode(ValidationMode.valueOf((String)validationMode));
        }
        if (objectAccessorProvider != null) {
            configuration.setObjectAccessorProvider((ObjectAccessorProvider)ObjectAccessorProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(objectAccessorProvider).newInstance()));
        }
        if (simpleTypeProvider != null) {
            configuration.setSimpleTypeConverterProvider((SimpleTypeConverterProvider)SimpleTypeConverterProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(simpleTypeProvider).newInstance()));
        }
        if (typeMappingRegistry != null) {
            configuration.setTypeMappingRegistry((TypeMappingRegistry)Thread.currentThread().getContextClassLoader().loadClass(typeMappingRegistry).newInstance());
        }
        if (validationProvider != null) {
            configuration.setValidatorProvider((ValidatorProvider)ValidatorProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(validationProvider).newInstance()));
        }
    }

    public static <A extends RbfLowLevelConfiguration> void setRbfConfiguration(RbfConfiguration<A> configuration, String validationMode, String validationProvider, String lowLevelConfiguration, String objectAccessorProvider, String lineFilter, String lineFilterLimit, String specialRecordDelimiter, String simpleTypeProvider, String typeMappingRegistry) throws Exception {
        JsefaConfigurations.setConfiguration(configuration, validationMode, validationProvider, objectAccessorProvider, simpleTypeProvider, typeMappingRegistry);
        if (lineFilter != null) {
            configuration.setLineFilter((LineFilter)LineFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(lineFilter).newInstance()));
        }
        if (lowLevelConfiguration != null) {
            configuration.setLowLevelConfiguration((RbfLowLevelConfiguration)Thread.currentThread().getContextClassLoader().loadClass(lowLevelConfiguration).newInstance());
        }
        if (lineFilterLimit != null) {
            configuration.setLineFilterLimit(Integer.valueOf(Integer.parseInt(lineFilterLimit)));
        }
        if (specialRecordDelimiter != null) {
            configuration.setSpecialRecordDelimiter(Character.valueOf(specialRecordDelimiter.charAt(0)));
        }
    }

    public static XmlConfiguration newXmlConfiguration(String lineBreak, String dataTypeDefaultNameRegistry, String lineIndentation, String lowLevelConfiguration, String namespaceManager, String dataTypeAttributeName, String validationMode, String validationProvider, String objectAccessorProvider, String simpleTypeProvider, String typeMappingRegistry) throws Exception {
        XmlConfiguration configuration = new XmlConfiguration();
        JsefaConfigurations.setConfiguration(configuration, validationMode, validationProvider, objectAccessorProvider, simpleTypeProvider, typeMappingRegistry);
        if (lineBreak != null) {
            configuration.setLineBreak(lineBreak);
        }
        if (dataTypeDefaultNameRegistry != null) {
            configuration.setDataTypeDefaultNameRegistry((XmlDataTypeDefaultNameRegistry)XmlDataTypeDefaultNameRegistry.class.cast(Thread.currentThread().getContextClassLoader().loadClass(dataTypeDefaultNameRegistry).newInstance()));
        }
        if (lineIndentation != null) {
            configuration.setLineIndentation(lineIndentation);
        }
        if (lowLevelConfiguration != null) {
            configuration.setLowLevelConfiguration((XmlLowLevelConfiguration)XmlLowLevelConfiguration.class.cast(Thread.currentThread().getContextClassLoader().loadClass(lowLevelConfiguration).newInstance()));
        }
        if (namespaceManager != null) {
            configuration.setNamespaceManager((NamespaceManager)NamespaceManager.class.cast(Thread.currentThread().getContextClassLoader().loadClass(namespaceManager).newInstance()));
        }
        if (dataTypeAttributeName != null) {
            configuration.setDataTypeAttributeName(QName.create((String)dataTypeAttributeName.substring(1, dataTypeAttributeName.indexOf("}")), (String)dataTypeAttributeName.substring(dataTypeAttributeName.indexOf("}") + 1)));
        }
        return configuration;
    }

    public static CsvConfiguration newCsvConfiguration(String defaultNoValueString, String defaultQuoteMode, String fieldDelimiter, String lineBreak, String quoteCharacter, String quoteCharacterEscapeMode, String useDelimiterAfterLastField, String validationMode, String validationProvider, String lineFilter, String lowLevelConfiguration, String lineFilterLimit, String objectAccessorProvider, String specialRecordDelimiter, String simpleTypeProvider, String typeMappingRegistry) throws Exception {
        CsvConfiguration configuration = new CsvConfiguration();
        JsefaConfigurations.setRbfConfiguration(configuration, validationMode, validationProvider, lowLevelConfiguration, objectAccessorProvider, lineFilter, lineFilterLimit, specialRecordDelimiter, simpleTypeProvider, typeMappingRegistry);
        if (defaultNoValueString != null) {
            configuration.setDefaultNoValueString(defaultNoValueString);
        }
        if (defaultQuoteMode != null) {
            configuration.setDefaultQuoteMode(QuoteMode.valueOf((String)defaultQuoteMode));
        }
        if (fieldDelimiter != null) {
            configuration.setFieldDelimiter(fieldDelimiter.charAt(0));
        }
        if (lineBreak != null) {
            configuration.setLineBreak(Langs.repalceEscapableChars((String)lineBreak));
        }
        if (quoteCharacter != null) {
            configuration.setQuoteCharacter(quoteCharacter.charAt(0));
        }
        if (quoteCharacterEscapeMode != null) {
            configuration.setQuoteCharacterEscapeMode(EscapeMode.valueOf((String)quoteCharacterEscapeMode));
        }
        if (useDelimiterAfterLastField != null) {
            configuration.setUseDelimiterAfterLastField(Boolean.parseBoolean(useDelimiterAfterLastField));
        }
        return configuration;
    }

    public static FlrConfiguration newFlrConfiguration(String defaultPadCharacter, String lineBreak, String validationMode, String validationProvider, String lineFilter, String lowLevelConfiguration, String lineFilterLimit, String objectAccessorProvider, String specialRecordDelimiter, String simpleTypeProvider, String typeMappingRegistry) throws Exception {
        FlrConfiguration configuration = new FlrConfiguration();
        JsefaConfigurations.setRbfConfiguration(configuration, validationMode, validationProvider, lowLevelConfiguration, objectAccessorProvider, lineFilter, lineFilterLimit, specialRecordDelimiter, simpleTypeProvider, typeMappingRegistry);
        if (lineBreak != null) {
            configuration.setLineBreak(Langs.repalceEscapableChars((String)lineBreak));
        }
        if (defaultPadCharacter != null) {
            configuration.setDefaultPadCharacter(defaultPadCharacter.charAt(0));
        }
        return configuration;
    }

    private JsefaConfigurations() {
    }
}

