/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsefa;

import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import net.sf.jsefa.Deserializer;
import net.sf.jsefa.common.lowlevel.filter.HeaderAndFooterFilter;
import net.sf.jsefa.common.lowlevel.filter.LineFilter;
import net.sf.jsefa.csv.CsvIOFactory;
import net.sf.jsefa.csv.config.CsvConfiguration;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.jsefa.JSefaReader;
import org.apache.batchee.jsefa.JsefaConfigurations;

@Documentation(value="Reads a CSV file using JSefa.")
public class JSefaCsvReader
extends JSefaReader {
    @Inject
    @BatchProperty
    @Documentation(value="Which ref or implementation to use to filter lines")
    private String lineFilter;
    @Inject
    @BatchProperty
    @Documentation(value="low level configuration implementation")
    private String lowLevelConfiguration;
    @Inject
    @BatchProperty
    @Documentation(value="if not using a custom line filter how many lines to filter")
    private String lineFilterLimit;
    @Inject
    @BatchProperty
    @Documentation(value="record delimiter")
    private String specialRecordDelimiter;
    @Inject
    @BatchProperty
    @Documentation(value="EOL")
    private String lineBreak;
    @Inject
    @BatchProperty
    @Documentation(value="which string to use for null values")
    private String defaultNoValueString;
    @Inject
    @BatchProperty
    @Documentation(value="quote mode (ALWAYS, ON_DEMAND, NEVER, DEFAULT)")
    private String defaultQuoteMode;
    @Inject
    @BatchProperty
    @Documentation(value="field delimiter")
    private String fieldDelimiter;
    @Inject
    @BatchProperty
    @Documentation(value="quote charater to use")
    private String quoteCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="escape mode (ESCAPE_CHARACTER, DOUBLING)")
    private String quoteCharacterEscapeMode;
    @Inject
    @BatchProperty
    @Documentation(value="should deliimter be used after last field")
    private String useDelimiterAfterLastField;
    @Inject
    @BatchProperty
    @Documentation(value="should the header be ignored")
    private Boolean ignoreHeader;
    @Inject
    @BatchProperty
    @Documentation(value="number of header lines")
    private Integer headerSize;

    @Override
    protected Deserializer initDeserializer() throws Exception {
        CsvConfiguration config = JsefaConfigurations.newCsvConfiguration(this.defaultNoValueString, this.defaultQuoteMode, this.fieldDelimiter, this.lineBreak, this.quoteCharacter, this.quoteCharacterEscapeMode, this.useDelimiterAfterLastField, this.validationMode, this.validationProvider, this.lineFilter, this.lowLevelConfiguration, this.lineFilterLimit, this.objectAccessorProvider, this.specialRecordDelimiter, this.simpleTypeProvider, this.typeMappingRegistry);
        if (config.getLineFilter() == null && Boolean.TRUE.equals(this.ignoreHeader)) {
            if (this.headerSize == null || this.headerSize == 0) {
                this.headerSize = 1;
            }
            config.setLineFilter((LineFilter)new HeaderAndFooterFilter(this.headerSize.intValue(), false, false));
        }
        return CsvIOFactory.createFactory((CsvConfiguration)config, (Class[])JsefaConfigurations.createObjectTypes(this.objectTypes)).createDeserializer();
    }
}

