/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.IllegalBatchPropertyException;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.jaxb.Property;
import org.apache.xbean.propertyeditor.PropertyEditors;

public class DependencyInjections {
    private DependencyInjections() {
    }

    public static void injectReferences(Object artifact, InjectionReferences injectionRefs) {
        Map<String, Field> propertyMap = DependencyInjections.findPropertyFields(artifact);
        if (injectionRefs.getProps() != null) {
            DependencyInjections.injectProperties(artifact, injectionRefs.getProps(), propertyMap);
        }
        DependencyInjections.injectBatchContextFields(artifact, injectionRefs.getJobContext(), injectionRefs.getStepContext());
    }

    private static void injectProperties(Object artifact, List<Property> props, Map<String, Field> propertyFieldMap) {
        if (props == null || propertyFieldMap == null) {
            return;
        }
        for (Map.Entry<String, Field> batchProperty : propertyFieldMap.entrySet()) {
            String propValue = DependencyInjections.getPropertyValue(props, batchProperty.getKey());
            try {
                if (propValue == null) continue;
                Field field = batchProperty.getValue();
                Type genericType = field.getGenericType();
                Class<?> type = field.getType();
                field.set(artifact, DependencyInjections.convertTo(propValue, genericType, type));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalBatchPropertyException("The given property value is not an instance of the declared field.", e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public static <T> T convertTo(String propValue, Type genericType, Class<T> type) {
        if (String.class.equals(type)) {
            return (T)propValue;
        }
        if (type == null || PropertyEditors.canConvert(type)) {
            return (T)PropertyEditors.getValue((Type)genericType, (String)propValue);
        }
        throw new IllegalArgumentException("Can't find a converter for type " + type);
    }

    public static String getPropertyValue(List<Property> props, String name) {
        if (props == null) {
            return null;
        }
        for (Property prop : props) {
            if (!name.equals(prop.getName())) continue;
            String propValue = prop.getValue();
            if ("".equals(propValue)) {
                return null;
            }
            return propValue;
        }
        return null;
    }

    private static void injectBatchContextFields(Object artifact, JobContext jobCtx, StepContext stepCtx) {
        for (Field field : artifact.getClass().getDeclaredFields()) {
            DependencyInjections.setAccessible(field);
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            try {
                if (JobContext.class.isAssignableFrom(field.getType()) && field.get(artifact) == null) {
                    field.set(artifact, jobCtx);
                    continue;
                }
                if (!StepContext.class.isAssignableFrom(field.getType()) || field.get(artifact) != null) continue;
                field.set(artifact, stepCtx);
            }
            catch (IllegalArgumentException e) {
                throw new BatchContainerRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    private static Map<String, Field> findPropertyFields(Object delegate) {
        HashMap<String, Field> propertyMap = null;
        Class<?> current = delegate.getClass();
        while (current.getName().contains("$$")) {
            current = current.getSuperclass();
        }
        while (current != null && current != Object.class) {
            for (Field field : current.getDeclaredFields()) {
                DependencyInjections.setAccessible(field);
                BatchProperty batchPropertyAnnotation = field.getAnnotation(BatchProperty.class);
                if (batchPropertyAnnotation == null) continue;
                if (propertyMap == null) {
                    propertyMap = new HashMap<String, Field>();
                }
                String batchPropName = null;
                batchPropName = batchPropertyAnnotation.name().equals("") ? field.getName() : batchPropertyAnnotation.name();
                if (propertyMap.containsKey(batchPropName)) {
                    throw new IllegalBatchPropertyException("There is already a batch property with this name: " + batchPropName);
                }
                propertyMap.put(batchPropName, field);
            }
            current = current.getSuperclass();
        }
        return propertyMap;
    }

    private static void setAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }
}

