/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.callback;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.spi.JobExecutionCallbackService;
import org.apache.batchee.util.Batches;

public class SimpleJobExecutionCallbackService
implements JobExecutionCallbackService {
    private final ConcurrentMap<Long, Collection<CountDownLatch>> waiters = new ConcurrentHashMap<Long, Collection<CountDownLatch>>();

    @Override
    public void onJobExecutionDone(RuntimeJobExecution jobExecution) {
        Collection toRealease = (Collection)this.waiters.remove(jobExecution.getExecutionId());
        if (toRealease != null) {
            for (CountDownLatch latch : toRealease) {
                latch.countDown();
            }
        }
    }

    @Override
    public void waitFor(long id) {
        InternalJobExecution finalCheckExec;
        Collection<CountDownLatch> toRealease = (CopyOnWriteArrayList)this.waiters.remove(id);
        if (toRealease == null) {
            toRealease = new CopyOnWriteArrayList();
            Collection existing = this.waiters.putIfAbsent(id, toRealease);
            if (existing != null) {
                toRealease = existing;
            }
        }
        if (Batches.isDone((finalCheckExec = ServicesManager.find().service(BatchKernelService.class).getJobExecution(id)).getBatchStatus())) {
            this.waiters.remove(id);
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        toRealease.add(latch);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new BatchContainerRuntimeException(e);
        }
    }

    @Override
    public void init(Properties batchConfig) {
    }
}

