/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.security;

import java.util.Properties;
import org.apache.batchee.spi.SecurityService;

public class DefaultSecurityService
implements SecurityService {
    protected String defaultUser;
    protected boolean allowDefault;

    @Override
    public boolean isAuthorized(long instanceId) {
        return this.isDefaultUserAuthorized();
    }

    @Override
    public boolean isAuthorized(String perm) {
        return this.isDefaultUserAuthorized();
    }

    @Override
    public String getLoggedUser() {
        return this.defaultUser;
    }

    private boolean isDefaultUserAuthorized() {
        return this.defaultUser.equals(this.getLoggedUser()) || this.allowDefault;
    }

    @Override
    public void init(Properties batchConfig) {
        this.defaultUser = batchConfig.getProperty("security.user", "jbatch");
        this.allowDefault = "true".equalsIgnoreCase(batchConfig.getProperty("security.anonymous-allowed", "false"));
    }

    public String toString() {
        return this.getClass().getName();
    }
}

