/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import javax.batch.api.chunk.CheckpointAlgorithm;

public final class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private long requests = 0L;
    private long checkpointBeginTime = 0L;
    private int time;
    private int item;
    private long currentTime = this.checkpointBeginTime = System.currentTimeMillis();

    public void endCheckpoint() throws Exception {
    }

    public boolean isReadyToCheckpointItem() throws Exception {
        boolean itemready;
        ++this.requests;
        boolean bl = itemready = this.requests >= (long)this.item;
        if (itemready) {
            this.requests = 0L;
        }
        return itemready;
    }

    public boolean isReadyToCheckpointTime() throws Exception {
        boolean timeready = false;
        this.currentTime = System.currentTimeMillis();
        long curdiff = this.currentTime - this.checkpointBeginTime;
        int diff = (int)curdiff / 1000;
        if (diff >= this.time) {
            timeready = true;
            this.checkpointBeginTime = System.currentTimeMillis();
        }
        return timeready;
    }

    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready = false;
        if (this.time == 0) {
            if (this.isReadyToCheckpointItem()) {
                ready = true;
            }
        } else if (this.isReadyToCheckpointItem() || this.isReadyToCheckpointTime()) {
            ready = true;
        }
        return ready;
    }

    public void setThresholds(int itemthreshold, int timethreshold) {
        this.item = itemthreshold;
        this.time = timethreshold;
    }

    public void beginCheckpoint() throws Exception {
        this.checkpointBeginTime = this.currentTime;
    }

    public int checkpointTimeout() throws Exception {
        return 0;
    }
}

