/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jpa.domain;

import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity;

@Entity
@NamedQueries(value={@NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByNameAndTag", query="select count(j) from JobInstanceEntity j where j.name = :name and j.tag = tag"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByName", query="select count(j) from JobInstanceEntity j where j.name = :name"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByExecution", query="select j from JobInstanceEntity j inner join j.executions e where e.executionId = :executionId"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findExternals", query="select j from JobInstanceEntity j where j.name not like :pattern"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByNameAndTag", query="select j from JobInstanceEntity j where j.name = :name and j.tag = tag"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByName", query="select j from JobInstanceEntity j where j.name = :name"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.deleteFromInstanceId", query="delete from JobInstanceEntity e where e.jobInstanceId = :instanceId")})
@Table(name="BATCH_JOBINSTANCE")
public class JobInstanceEntity {
    public static final String TABLE_NAME = "BATCH_JOBINSTANCE";
    @Id
    @GeneratedValue
    private long jobInstanceId;
    private String name;
    private String tag;
    @Lob
    private String jobXml;
    @Enumerated(value=EnumType.STRING)
    private BatchStatus batchStatus;
    private String step;
    private String exitStatus;
    private String restartOn;
    private long latestExecution;
    @OneToMany(mappedBy="instance")
    private List<JobExecutionEntity> executions;

    public long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setJobXml(String jobXml) {
        this.jobXml = jobXml;
    }

    public String getJobXml() {
        return this.jobXml;
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public void setRestartOn(String restartOn) {
        this.restartOn = restartOn;
    }

    public long getLatestExecution() {
        return this.latestExecution;
    }

    public void setLatestExecution(long latestExecution) {
        this.latestExecution = latestExecution;
    }

    public List<JobExecutionEntity> getExecutions() {
        return this.executions;
    }

    public JobInstance toJobInstance() {
        JobInstanceImpl jobInstance = new JobInstanceImpl(this.jobInstanceId, this.jobXml);
        jobInstance.setJobName(this.name);
        return jobInstance;
    }

    public static interface Queries {
        public static final String COUNT_BY_NAME_AND_TAG = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByNameAndTag";
        public static final String COUNT_BY_NAME = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.countByName";
        public static final String FIND_BY_NAME = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByName";
        public static final String FIND_BY_NAME_AND_TAG = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByNameAndTag";
        public static final String FIND_EXTERNALS = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findExternals";
        public static final String FIND_FROM_EXECUTION = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.findByExecution";
        public static final String DELETE_BY_INSTANCE_ID = "org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity.deleteFromInstanceId";
    }
}

