/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence.jpa.domain;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.batchee.container.services.persistence.jpa.domain.JobInstanceEntity;
import org.apache.batchee.container.services.persistence.jpa.domain.PropertyHelper;

@Entity
@NamedQueries(value={@NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.mostRecent", query="SELECT e FROM JobExecutionEntity e WHERE e.instance.jobInstanceId = :instanceId ORDER BY e.createTime DESC"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance", query="SELECT e FROM JobExecutionEntity e WHERE e.instance.jobInstanceId = :instanceId"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByInstanceId", query="delete from JobExecutionEntity e where e.instance.jobInstanceId = :instanceId"), @NamedQuery(name="org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findRunning", query="SELECT e FROM JobExecutionEntity e WHERE e.batchStatus in :statuses and e.instance.name = :name")})
@Table(name="BATCH_JOBEXECUTION")
public class JobExecutionEntity {
    public static final String TABLE_NAME = "BATCH_JOBEXECUTION";
    @Id
    @GeneratedValue
    private long executionId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp createTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp startTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp endTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp updateTime;
    @Enumerated(value=EnumType.STRING)
    private BatchStatus batchStatus;
    private String exitStatus;
    @Lob
    private String jobProperties;
    @ManyToOne
    private JobInstanceEntity instance;

    public long getExecutionId() {
        return this.executionId;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Properties getJobProperties() {
        return PropertyHelper.stringToProperties(this.jobProperties);
    }

    public void setJobProperties(Properties jobProperties) {
        this.jobProperties = PropertyHelper.propertiesToString(jobProperties);
    }

    public JobInstanceEntity getInstance() {
        return this.instance;
    }

    public void setInstance(JobInstanceEntity instance) {
        this.instance = instance;
    }

    public static interface Queries {
        public static final String MOST_RECENT = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.mostRecent";
        public static final String FIND_BY_INSTANCE = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findByInstance";
        public static final String FIND_RUNNING = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.findRunning";
        public static final String DELETE_BY_INSTANCE_ID = "org.apache.batchee.container.services.persistence.jpa.domain.JobExecutionEntity.deleteByInstanceId";
        public static final List<BatchStatus> RUNNING_STATUSES = Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING, BatchStatus.STOPPING);
    }
}

