/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.factory;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.batchee.container.cdi.BatchCDIInjectionExtension;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.services.factory.DefaultBatchArtifactFactory;
import org.apache.batchee.spi.BatchArtifactFactory;

public class CDIBatchArtifactFactory
extends DefaultBatchArtifactFactory {
    @Override
    public BatchArtifactFactory.Instance load(String batchId) {
        try {
            BeanManager bm = this.getBeanManager();
            if (bm == null) {
                return super.load(batchId);
            }
            Set beans = bm.getBeans(batchId);
            Bean bean = bm.resolve(beans);
            if (bean == null) {
                return super.load(batchId);
            }
            Class clazz = bean.getBeanClass();
            final CreationalContext creationalContext = bm.createCreationalContext((Contextual)bean);
            Object artifactInstance = bm.getReference(bean, (Type)clazz, creationalContext);
            if (Dependent.class.equals((Object)bean.getScope()) || !bm.isNormalScope(bean.getScope())) {
                return new BatchArtifactFactory.Instance(artifactInstance, new Closeable(){

                    @Override
                    public void close() throws IOException {
                        creationalContext.release();
                    }
                });
            }
            return new BatchArtifactFactory.Instance(artifactInstance, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
    }

    protected BeanManager getBeanManager() {
        BatchCDIInjectionExtension instance = BatchCDIInjectionExtension.getInstance();
        if (instance == null) {
            return null;
        }
        return instance.getBeanManager();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

