/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.transaction;

import java.util.Properties;
import javax.batch.runtime.context.StepContext;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.exception.TransactionManagementException;
import org.apache.batchee.container.services.transaction.DefaultNonTransactionalManager;
import org.apache.batchee.container.services.transaction.JTAUserTransactionAdapter;
import org.apache.batchee.spi.TransactionManagementService;
import org.apache.batchee.spi.TransactionManagerAdapter;

public class DefaultBatchTransactionService
implements TransactionManagementService {
    protected static final int DEFAULT_TRANSACTION_TIMEOUT = 180;
    protected Properties batchConfig = null;

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
        this.batchConfig = batchConfig;
    }

    protected TransactionManagerAdapter getTransactionManager() {
        try {
            DefaultBatchTransactionService.class.getClassLoader().loadClass("javax.transaction.UserTransaction");
            return new JTAUserTransactionAdapter();
        }
        catch (Throwable ncdfe) {
            return new DefaultNonTransactionalManager();
        }
    }

    @Override
    public TransactionManagerAdapter getTransactionManager(StepContext stepContext) throws TransactionManagementException {
        TransactionManagerAdapter transactionManager = this.getTransactionManager();
        try {
            transactionManager.setTransactionTimeout(this.getTransactionTimeout(stepContext));
        }
        catch (Exception e) {
            throw new TransactionManagementException(e);
        }
        return transactionManager;
    }

    private int getTransactionTimeout(StepContext stepContext) {
        String propertyTimeOut;
        Properties p = stepContext.getProperties();
        int timeout = 180;
        if (p != null && !p.isEmpty() && (propertyTimeOut = p.getProperty("javax.transaction.global.timeout")) != null && !propertyTimeOut.isEmpty()) {
            timeout = Integer.parseInt(propertyTimeOut, 10);
        }
        return timeout;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

