/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.common;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.batchee.jaxrs.common.RestProperties;

public class RestJobExecution {
    private long id;
    private String name;
    private BatchStatus batchStatus;
    private Date startTime;
    private Date endTime;
    private String exitStatus;
    private Date createTime;
    private Date lastUpdatedTime;
    private RestProperties jobParameters;

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setJobParameters(RestProperties jobParameters) {
        this.jobParameters = jobParameters;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public RestProperties getJobParameters() {
        return this.jobParameters;
    }

    public static List<RestJobExecution> wrap(List<JobExecution> jobExecutions) {
        ArrayList<RestJobExecution> executions = new ArrayList<RestJobExecution>(jobExecutions.size());
        for (JobExecution exec : jobExecutions) {
            executions.add(RestJobExecution.wrap(exec));
        }
        return executions;
    }

    public static RestJobExecution wrap(JobExecution jobExecution) {
        RestJobExecution execution = new RestJobExecution();
        execution.setId(jobExecution.getExecutionId());
        execution.setName(jobExecution.getJobName());
        execution.setBatchStatus(jobExecution.getBatchStatus());
        execution.setStartTime(jobExecution.getStartTime());
        execution.setEndTime(jobExecution.getEndTime());
        execution.setExitStatus(jobExecution.getExitStatus());
        execution.setCreateTime(jobExecution.getCreateTime());
        execution.setLastUpdatedTime(jobExecution.getLastUpdatedTime());
        execution.setJobParameters(RestProperties.wrap(jobExecution.getJobParameters()));
        return execution;
    }
}

