/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.common;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.batchee.jaxrs.common.RestEntry;

public class RestProperties {
    private List<RestEntry> entries = new LinkedList<RestEntry>();

    public void setEntries(List<RestEntry> entries) {
        this.entries = entries;
    }

    public List<RestEntry> getEntries() {
        return this.entries;
    }

    public static RestProperties wrap(Properties parameters) {
        RestProperties p = new RestProperties();
        for (Map.Entry<Object, Object> e : parameters.entrySet()) {
            RestEntry restEntry = new RestEntry();
            restEntry.setKey(e.getKey().toString());
            if (e.getValue() != null) {
                restEntry.setValue(e.getValue().toString());
            }
            p.getEntries().add(restEntry);
        }
        return p;
    }

    public static Properties unwrap(RestProperties jobParameters) {
        Properties p = new Properties();
        for (RestEntry e : jobParameters.getEntries()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    public static Properties toProperties(RestProperties props) {
        Properties p = new Properties();
        if (props != null && props.getEntries() != null) {
            for (RestEntry entry : props.getEntries()) {
                p.put(entry.getKey(), entry.getValue());
            }
        }
        return p;
    }
}

