/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jaxrs.client;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.jaxrs.client.impl.JobExecutionImpl;
import org.apache.batchee.jaxrs.client.impl.JobInstanceImpl;
import org.apache.batchee.jaxrs.client.impl.MetricImpl;
import org.apache.batchee.jaxrs.client.impl.StepExecutionImpl;
import org.apache.batchee.jaxrs.common.JBatchResource;
import org.apache.batchee.jaxrs.common.RestJobExecution;
import org.apache.batchee.jaxrs.common.RestJobInstance;
import org.apache.batchee.jaxrs.common.RestMetric;
import org.apache.batchee.jaxrs.common.RestProperties;
import org.apache.batchee.jaxrs.common.RestStepExecution;

abstract class BatchEEJAXRSClientBase<RESPONSE>
implements InvocationHandler {
    private static final Map<String, Method> RESOURCE_MAPPINGS = new HashMap<String, Method>();

    BatchEEJAXRSClientBase() {
    }

    protected abstract Object extractEntity(RESPONSE var1, Type var2) throws Throwable;

    protected abstract RESPONSE doInvoke(Method var1, Method var2, Object[] var3) throws Throwable;

    protected abstract void close();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method jaxrsMethod;
        if (Closeable.class.equals(method.getDeclaringClass())) {
            this.close();
        }
        if ((jaxrsMethod = RESOURCE_MAPPINGS.get(method.getName())) == null) {
            throw new IllegalArgumentException("Can't find mapping for " + method);
        }
        RESPONSE response = this.doInvoke(jaxrsMethod, method, args);
        return BatchEEJAXRSClientBase.convertReturnedValue(this.extractEntity(response, jaxrsMethod.getGenericReturnType()), method.getGenericReturnType());
    }

    protected static Object convertParam(Object arg, Type type) {
        if (arg == null) {
            return null;
        }
        if (String.class.equals((Object)type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type)) {
            return arg;
        }
        if (Properties.class.equals((Object)type)) {
            Properties props = (Properties)Properties.class.cast(arg);
            return RestProperties.wrap((Properties)props);
        }
        if (JobInstance.class.equals((Object)type)) {
            JobInstance instance = (JobInstance)JobInstance.class.cast(arg);
            return new RestJobInstance(instance.getJobName(), instance.getInstanceId());
        }
        throw new IllegalArgumentException("Unexpected type " + type + " for a parameter");
    }

    protected static Object convertReturnedValue(Object arg, Type type) {
        if (arg == null || Void.TYPE.equals(type)) {
            return null;
        }
        if (String.class.equals((Object)type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type)) {
            return arg;
        }
        if (Properties.class.equals((Object)type)) {
            RestProperties props = (RestProperties)RestProperties.class.cast(arg);
            return RestProperties.toProperties((RestProperties)props);
        }
        if (JobInstance.class.equals((Object)type)) {
            RestJobInstance rij = (RestJobInstance)RestJobInstance.class.cast(arg);
            return new JobInstanceImpl(rij.getName(), rij.getId());
        }
        if (JobExecution.class.equals((Object)type)) {
            RestJobExecution jobExec = (RestJobExecution)RestJobExecution.class.cast(arg);
            return new JobExecutionImpl(jobExec.getId(), jobExec.getName(), RestProperties.toProperties((RestProperties)jobExec.getJobParameters()), jobExec.getBatchStatus(), jobExec.getExitStatus(), jobExec.getCreateTime(), jobExec.getStartTime(), jobExec.getEndTime(), jobExec.getLastUpdatedTime());
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (Set.class.equals((Object)pt.getRawType()) && String.class.equals((Object)pt.getActualTypeArguments()[0])) {
                String[] names = (String[])String[].class.cast(arg);
                HashSet converted = new HashSet(names.length);
                Collections.addAll(converted, names);
                return converted;
            }
            if (List.class.equals((Object)pt.getRawType())) {
                if (JobInstance.class.equals((Object)pt.getActualTypeArguments()[0])) {
                    RestJobInstance[] instances = (RestJobInstance[])RestJobInstance[].class.cast(arg);
                    ArrayList<JobInstanceImpl> converted = new ArrayList<JobInstanceImpl>(instances.length);
                    for (RestJobInstance rij : instances) {
                        converted.add(new JobInstanceImpl(rij.getName(), rij.getId()));
                    }
                    return converted;
                }
                if (Long.class.equals((Object)pt.getActualTypeArguments()[0])) {
                    Long[] ids = (Long[])Long[].class.cast(arg);
                    ArrayList converted = new ArrayList(ids.length);
                    Collections.addAll(converted, ids);
                    return converted;
                }
                if (JobExecution.class.equals((Object)pt.getActualTypeArguments()[0])) {
                    RestJobExecution[] executions = (RestJobExecution[])RestJobExecution[].class.cast(arg);
                    ArrayList<JobExecutionImpl> converted = new ArrayList<JobExecutionImpl>(executions.length);
                    for (RestJobExecution exec : executions) {
                        converted.add(new JobExecutionImpl(exec.getId(), exec.getName(), RestProperties.toProperties((RestProperties)exec.getJobParameters()), exec.getBatchStatus(), exec.getExitStatus(), exec.getCreateTime(), exec.getStartTime(), exec.getEndTime(), exec.getLastUpdatedTime()));
                    }
                    return converted;
                }
                if (StepExecution.class.equals((Object)pt.getActualTypeArguments()[0])) {
                    RestStepExecution[] executions = (RestStepExecution[])RestStepExecution[].class.cast(arg);
                    ArrayList<StepExecutionImpl> converted = new ArrayList<StepExecutionImpl>(executions.length);
                    for (RestStepExecution exec : executions) {
                        converted.add(new StepExecutionImpl(exec.getId(), exec.getName(), exec.getBatchStatus(), exec.getExitStatus(), exec.getStartTime(), exec.getEndTime(), null, BatchEEJAXRSClientBase.toMetrics(exec.getMetrics())));
                    }
                    return converted;
                }
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type + " for a returned type");
    }

    private static Metric[] toMetrics(List<RestMetric> metrics) {
        if (metrics == null) {
            return null;
        }
        Metric[] array = new Metric[metrics.size()];
        int i = 0;
        for (RestMetric m : metrics) {
            array[i++] = new MetricImpl(m.getType(), m.getValue());
        }
        return array;
    }

    static {
        for (Method m : JBatchResource.class.getMethods()) {
            if (Object.class.equals(m.getDeclaringClass())) continue;
            RESOURCE_MAPPINGS.put(m.getName(), m);
        }
    }
}

