/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.TransactionalWriter;
import org.apache.batchee.jackson.DefaultFieldNameGenerator;
import org.apache.batchee.jackson.FieldNameGenerator;
import org.apache.batchee.jackson.Jacksons;

@Documentation(value="Write a JSON file using jackson")
public class JacksonJSonWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="output file")
    private String file;
    @Inject
    @BatchProperty
    @Documentation(value="output encoding")
    private String encoding;
    @Inject
    @BatchProperty
    @Documentation(value="DeserializationFeature and SerializationFeature comma separated key-value configurations")
    private String configuration;
    @Inject
    @BatchProperty
    @Documentation(value="is the array wrapped in an object or not")
    private String skipRoot;
    @Inject
    @BatchProperty
    @Documentation(value="how to generate field names for each item, default uses item1, item2, ...")
    private String fieldNameGeneratorClass;
    private JsonGenerator generator;
    private TransactionalWriter writer;
    private FieldNameGenerator fieldNameGenerator = null;

    public void open(Serializable checkpoint) throws Exception {
        File outputFile = new File(this.file);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new BatchRuntimeException("Can't create " + outputFile.getAbsolutePath());
        }
        ObjectMapper mapper = Jacksons.newMapper(this.configuration);
        this.writer = new TransactionalWriter(outputFile, this.encoding, checkpoint);
        this.generator = mapper.getFactory().createGenerator((Writer)this.writer);
        if (this.fieldNameGeneratorClass != null) {
            this.fieldNameGenerator = "default".equals(this.fieldNameGeneratorClass) ? new DefaultFieldNameGenerator() : (FieldNameGenerator)FieldNameGenerator.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.fieldNameGeneratorClass).newInstance());
        }
        if (this.useGlobalWrapper()) {
            if (this.fieldNameGenerator != null) {
                this.generator.writeStartObject();
            } else {
                this.generator.writeStartArray();
            }
        }
    }

    public void close() throws Exception {
        if (this.generator != null) {
            if (this.useGlobalWrapper()) {
                if (this.fieldNameGenerator != null) {
                    this.generator.writeEndObject();
                } else {
                    this.generator.writeEndArray();
                }
            }
            this.generator.close();
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            if (this.fieldNameGenerator != null) {
                this.generator.writeFieldName(this.fieldNameGenerator.nextName());
            }
            this.generator.writeObject(o);
        }
        this.writer.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.writer.position());
    }

    private boolean useGlobalWrapper() {
        return this.skipRoot == null || !"true".equalsIgnoreCase(this.skipRoot);
    }
}

