/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.apache.batchee.extras.transaction.CountedReader;
import org.apache.batchee.jackson.Jacksons;

public class JacksonJsonReader
extends CountedReader {
    @Inject
    @BatchProperty
    private String file;
    @Inject
    @BatchProperty
    private String type;
    @Inject
    @BatchProperty
    private String configuration;
    @Inject
    @BatchProperty
    private String skipRoot;
    private JsonParser parser;
    private Class<?> clazz;
    private JsonToken end = null;

    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        ObjectMapper mapper = Jacksons.newMapper(this.configuration);
        this.parser = mapper.getFactory().createParser(new File(this.file));
        this.clazz = this.type != null ? Thread.currentThread().getContextClassLoader().loadClass(this.type) : null;
        if (this.skipRoot == null || "true".equalsIgnoreCase(this.skipRoot)) {
            JsonToken token = this.parser.nextToken();
            this.end = token == JsonToken.START_ARRAY ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
        }
    }

    protected Object doRead() throws Exception {
        JsonToken token;
        while ((token = this.parser.nextToken()) != JsonToken.START_OBJECT && token != this.end || this.end == null && (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT)) {
        }
        if (this.clazz == null) {
            this.parser.readValueAsTree();
        }
        return this.parser.readValueAs(this.clazz);
    }

    public void close() throws Exception {
        if (this.parser != null) {
            this.parser.close();
        }
    }
}

