/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.hazelcast.HazelcastClientFactory;
import org.apache.batchee.hazelcast.HazelcastMemberFactory;

public class HazelcastSynchroInstanceAware {
    @Inject
    @BatchProperty
    @Documentation(value="The hazelcast instance name")
    protected String instanceName;
    @Inject
    @BatchProperty
    @Documentation(value="The hazelcast xml configuration")
    protected String xmlConfiguration;
    @Inject
    @BatchProperty
    @Documentation(value="Is the instance local, if false the component will create a client")
    protected String local;
    @Inject
    @BatchProperty
    @Documentation(value="The lock name to use")
    protected String lockName;

    protected HazelcastInstance instance() throws IOException {
        if (this.local == null || "true".equalsIgnoreCase(this.local)) {
            return HazelcastMemberFactory.findOrCreateMember(this.xmlConfiguration, this.instanceName());
        }
        return HazelcastClientFactory.newClient(this.xmlConfiguration);
    }

    protected String instanceName() {
        if (this.instanceName == null) {
            this.instanceName = "hazelcast";
        }
        return this.instanceName;
    }

    protected String lockName() {
        if (this.lockName == null) {
            this.lockName = this.getClass().getSimpleName();
        }
        return this.lockName;
    }

    protected FencedLock findLock() throws IOException {
        return this.instance().getCPSubsystem().getLock(this.lockName());
    }
}

