/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.groovy;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.groovy.Groovys;

@Documentation(value="Reads and executes a writer from a groovy script")
public class GroovyItemWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="The script to execute")
    private String scriptPath;
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    private ItemWriter delegate;
    private Groovys.GroovyInstance<ItemWriter> groovyInstance;

    public void open(Serializable checkpoint) throws Exception {
        this.groovyInstance = Groovys.newInstance(ItemWriter.class, this.scriptPath, this.jobContext, this.stepContext);
        this.delegate = this.groovyInstance.getInstance();
        this.delegate.open(checkpoint);
    }

    public void close() throws Exception {
        this.delegate.close();
        this.groovyInstance.release();
    }

    public void writeItems(List<Object> items) throws Exception {
        this.delegate.writeItems(items);
    }

    public Serializable checkpointInfo() throws Exception {
        return this.delegate.checkpointInfo();
    }
}

