/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.groovy;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.groovy.Groovys;

@Documentation(value="Reads and executes a processor from a groovy script")
public class GroovyItemProcessor
implements ItemProcessor {
    @Inject
    @BatchProperty
    @Documentation(value="The script to execute")
    private String scriptPath;
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    private ItemProcessor delegate;
    private Groovys.GroovyInstance<ItemProcessor> groovyInstance;

    public Object processItem(Object item) throws Exception {
        this.groovyInstance = Groovys.newInstance(ItemProcessor.class, this.scriptPath, this.jobContext, this.stepContext);
        this.delegate = this.groovyInstance.getInstance();
        try {
            Object object = this.delegate.processItem(item);
            return object;
        }
        finally {
            this.groovyInstance.release();
        }
    }
}

