/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.groovy;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.Batchlet;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.groovy.Groovys;

@Documentation(value="Reads and executes a batchlet from a groovy script")
public class GroovyBatchlet
implements Batchlet {
    @Inject
    @BatchProperty
    @Documentation(value="The script to execute")
    private String scriptPath;
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    private Groovys.GroovyInstance<Batchlet> groovyInstance;
    private Batchlet delegate = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        GroovyBatchlet groovyBatchlet = this;
        synchronized (groovyBatchlet) {
            this.groovyInstance = Groovys.newInstance(Batchlet.class, this.scriptPath, this.jobContext, this.stepContext);
            this.delegate = this.groovyInstance.getInstance();
        }
        return this.delegate.process();
    }

    public synchronized void stop() throws Exception {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }
}

