/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;

public final class Groovys {
    public static <T> GroovyInstance<T> newInstance(Class<T> expected, String path, JobContext jobContext, StepContext stepContext) throws IllegalAccessException, InstantiationException {
        Class clazz;
        if (path == null) {
            throw new BatchRuntimeException("no script configured expected");
        }
        File script = new File(path);
        if (!script.exists()) {
            throw new BatchRuntimeException("Can't find script: " + path);
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(tccl);
        try {
            clazz = loader.parseClass(script);
        }
        catch (IOException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
        T delegate = expected.cast(clazz.newInstance());
        Groovys.injectIfBatcheeIfAvailable(tccl, delegate, jobContext, stepContext);
        return new GroovyInstance<T>(loader, delegate);
    }

    private static <T> void injectIfBatcheeIfAvailable(ClassLoader tccl, T delegate, JobContext jobContext, StepContext stepContext) {
        try {
            Class<?> dependencyInjections = tccl.loadClass("org.apache.batchee.container.util.DependencyInjections");
            Class<?> injectionReferences = tccl.loadClass("org.apache.batchee.container.proxy.InjectionReferences");
            Method inject = dependencyInjections.getMethod("injectReferences", Object.class, injectionReferences);
            Constructor<?> injectionReferencesConstructor = injectionReferences.getConstructors()[0];
            inject.invoke(null, delegate, injectionReferencesConstructor.newInstance(jobContext, stepContext, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Groovys() {
    }

    public static class GroovyInstance<T> {
        private final GroovyClassLoader loader;
        private final T instance;

        public GroovyInstance(GroovyClassLoader loader, T instance) {
            this.loader = loader;
            this.instance = instance;
        }

        public void release() throws IOException {
            this.loader.clearCache();
            if (Closeable.class.isInstance(this.loader)) {
                ((Closeable)Closeable.class.cast(this.loader)).close();
            }
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

