/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.transaction.integration;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batchee.extras.transaction.integration.JTASynchronizationService;
import org.apache.batchee.extras.transaction.integration.NoopSynchronizationService;
import org.apache.batchee.extras.transaction.integration.SynchronizationService;

public final class Synchronizations {
    private static final Logger LOGGER;
    public static final SynchronizationService DELEGATE;
    public static final boolean ACTIVE;

    private Synchronizations() {
    }

    public static void registerSynchronization(SynchronizationService.Synchronization s) {
        DELEGATE.registerSynchronization(s);
    }

    public static boolean hasTransaction() {
        return DELEGATE.hasTransaction();
    }

    public static void put(Object key, Object value) {
        DELEGATE.put(key, value);
    }

    public static Object get(Object key) {
        return DELEGATE.get(key);
    }

    static {
        SynchronizationService service;
        LOGGER = Logger.getLogger(Synchronizations.class.getName());
        boolean active = true;
        try {
            Synchronizations.class.getClassLoader().loadClass("jakarta.transaction.UserTransaction");
            service = new JTASynchronizationService("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Throwable e) {
            LOGGER.info("UserTransaction or TransactionSynchronizationRegistry not found, Transactional* components will ignore transactionanility");
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.SEVERE, "UserTransaction or TransactionSynchronizationRegistry not found, Transactional* components will not work", e);
            }
            active = false;
            service = new NoopSynchronizationService();
        }
        ACTIVE = active;
        DELEGATE = service;
    }
}

