/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.transaction.integration;

import javax.batch.operations.BatchRuntimeException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.batchee.extras.transaction.integration.SynchronizationService;

public class JTASynchronizationService
implements SynchronizationService {
    private final TransactionSynchronizationRegistry delegate;

    public JTASynchronizationService(String jndi) {
        try {
            this.delegate = (TransactionSynchronizationRegistry)TransactionSynchronizationRegistry.class.cast(new InitialContext().lookup(jndi));
        }
        catch (NamingException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    @Override
    public void registerSynchronization(SynchronizationService.Synchronization s) {
        this.delegate.registerInterposedSynchronization((Synchronization)new SynchronizationAdapter(s));
    }

    @Override
    public boolean hasTransaction() {
        return this.delegate.getTransactionStatus() == 0;
    }

    @Override
    public void put(Object key, Object value) {
        this.delegate.putResource(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.getResource(key);
    }

    private static class SynchronizationAdapter
    implements Synchronization {
        private final SynchronizationService.Synchronization delegate;

        public SynchronizationAdapter(SynchronizationService.Synchronization s) {
            this.delegate = s;
        }

        public void beforeCompletion() {
            this.delegate.beforeCompletion();
        }

        public void afterCompletion(int status) {
            if (status == 4) {
                this.delegate.afterRollback();
            } else if (status == 3) {
                this.delegate.afterCommit();
            } else {
                throw new BatchRuntimeException("Unexpected status " + status);
            }
        }
    }
}

