/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.flat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import org.apache.batchee.extras.flat.LineMapper;
import org.apache.batchee.extras.locator.BeanLocator;
import org.apache.batchee.extras.transaction.CountedReader;

public class FlatFileItemReader
extends CountedReader
implements ItemReader {
    @Inject
    @BatchProperty
    private String locator;
    @Inject
    @BatchProperty
    private String lineMapper;
    @Inject
    @BatchProperty
    private String input;
    @Inject
    @BatchProperty(name="comments")
    private String commentStr;
    private BufferedReader reader = null;
    private String[] comments = new String[0];
    private BeanLocator.LocatorInstance<LineMapper> mapper;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        if (this.input == null) {
            throw new BatchRuntimeException("Can't find any input");
        }
        File file = new File(this.input);
        if (!file.exists()) {
            throw new BatchRuntimeException("'" + this.input + "' doesn't exist");
        }
        this.mapper = this.lineMapper != null ? BeanLocator.Finder.get(this.locator).newInstance(LineMapper.class, this.lineMapper) : null;
        if (this.commentStr == null) {
            this.commentStr = "#";
        }
        this.comments = this.commentStr.split(",");
        this.reader = new BufferedReader(new FileReader(file));
        super.open(checkpoint);
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.mapper != null) {
            this.mapper.release();
        }
    }

    @Override
    protected Object doRead() throws Exception {
        String line;
        do {
            if ((line = this.reader.readLine()) == null) {
                return null;
            }
            this.incrementReaderCount();
        } while (this.isComment(line));
        return this.preReturn(line, this.items);
    }

    protected boolean isComment(String line) {
        for (String prefix : this.comments) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected Object preReturn(String rawLine, long lineNumber) {
        if (this.mapper != null) {
            return this.mapper.getValue().map(rawLine, lineNumber);
        }
        return rawLine;
    }
}

