/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.transaction.integration;

import org.apache.batchee.extras.transaction.integration.JTASynchronizationService;
import org.apache.batchee.extras.transaction.integration.NoopSynchronizationService;
import org.apache.batchee.extras.transaction.integration.SynchronizationService;

public final class Synchronizations {
    public static final SynchronizationService DELEGATE;
    public static final boolean ACTIVE;

    private Synchronizations() {
    }

    public static void registerSynchronization(SynchronizationService.Synchronization s) {
        DELEGATE.registerSynchronization(s);
    }

    public static boolean hasTransaction() {
        return DELEGATE.hasTransaction();
    }

    public static void put(Object key, Object value) {
        DELEGATE.put(key, value);
    }

    public static Object get(Object key) {
        return DELEGATE.get(key);
    }

    static {
        SynchronizationService service;
        boolean active = true;
        try {
            Synchronizations.class.getClassLoader().loadClass("javax.transaction.UserTransaction");
            service = new JTASynchronizationService("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Throwable e) {
            active = false;
            service = new NoopSynchronizationService();
        }
        ACTIVE = active;
        DELEGATE = service;
    }
}

