/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.stax;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.apache.batchee.extras.stax.util.JAXBContextFactory;
import org.apache.batchee.extras.stax.util.SAXStAXHandler;
import org.apache.batchee.extras.transaction.TransactionalWriter;

public class StaxItemWriter
implements ItemWriter {
    @Inject
    @BatchProperty(name="marshallingClasses")
    private String marshallingClasses;
    @Inject
    @BatchProperty(name="marshallingPackage")
    private String marshallingPackage;
    @Inject
    @BatchProperty(name="rootTag")
    private String rootTag;
    @Inject
    @BatchProperty(name="encoding")
    private String encoding;
    @Inject
    @BatchProperty(name="version")
    private String version;
    @Inject
    @BatchProperty(name="output")
    private String output;
    private Marshaller marshaller;
    private XMLEventWriter writer;
    private XMLEventFactory xmlEventFactory;
    private TransactionalWriter txWriter;

    public void open(Serializable checkpoint) throws Exception {
        if (this.output == null) {
            throw new BatchRuntimeException("output should be set");
        }
        if (this.marshallingPackage == null && this.marshallingClasses == null) {
            throw new BatchRuntimeException("marshallingPackage should be set");
        }
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (this.rootTag == null) {
            this.rootTag = "root";
        }
        if (this.version == null) {
            this.version = "1.0";
        }
        this.marshaller = JAXBContextFactory.getJaxbContext(this.marshallingPackage, this.marshallingClasses).createMarshaller();
        File file = new File(this.output);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new BatchRuntimeException("Output parent file can't be created");
        }
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        this.woodStoxConfig(xmlOutputFactory);
        this.xmlEventFactory = XMLEventFactory.newFactory();
        this.txWriter = new TransactionalWriter(file, this.encoding, checkpoint);
        this.writer = xmlOutputFactory.createXMLEventWriter(this.txWriter);
        if (this.txWriter.position() == 0L) {
            this.writer.add(this.xmlEventFactory.createStartDocument(this.encoding, this.version));
            this.writer.add(this.xmlEventFactory.createStartElement("", "", this.rootTag));
            this.writer.flush();
        }
    }

    private void woodStoxConfig(XMLOutputFactory xmlOutputFactory) {
        if (xmlOutputFactory.isPropertySupported("com.ctc.wstx.automaticEndElements")) {
            xmlOutputFactory.setProperty("com.ctc.wstx.automaticEndElements", Boolean.FALSE);
        }
        if (xmlOutputFactory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
            xmlOutputFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
        }
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.add(this.xmlEventFactory.createEndElement("", "", this.rootTag));
            this.writer.add(this.xmlEventFactory.createEndDocument());
            this.writer.close();
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.marshaller.marshal(item, (Result)new SAXResult(new SAXStAXHandler(this.writer, this.xmlEventFactory)));
        }
        this.writer.flush();
        this.txWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.txWriter.position());
    }
}

