/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.inject.Inject;
import org.apache.batchee.extras.jdbc.JdbcConnectionConfiguration;
import org.apache.batchee.extras.jdbc.ObjectMapper;
import org.apache.batchee.extras.locator.BeanLocator;
import org.apache.batchee.extras.transaction.integration.Synchronizations;

public class JdbcWriter
extends JdbcConnectionConfiguration
implements ItemWriter {
    @Inject
    @BatchProperty
    private String locator;
    @Inject
    @BatchProperty(name="mapper")
    private String mapperStr;
    @Inject
    @BatchProperty
    private String sql;
    private BeanLocator.LocatorInstance<ObjectMapper> mapper;

    public void open(Serializable checkpoint) throws Exception {
        this.mapper = BeanLocator.Finder.get(this.locator).newInstance(ObjectMapper.class, this.mapperStr);
    }

    public void close() throws Exception {
        if (this.mapper != null) {
            this.mapper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItems(List<Object> items) throws Exception {
        Connection c = this.connection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection().prepareStatement(this.sql);
            for (Object item : items) {
                this.mapper.getValue().map(item, preparedStatement);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            if (!Synchronizations.hasTransaction()) {
                c.commit();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            c.close();
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

