/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.flat;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import org.apache.batchee.extras.transaction.TransactionalWriter;

public class FlatFileItemWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    private String output;
    @Inject
    @BatchProperty
    private String encoding;
    @Inject
    @BatchProperty(name="line.separator")
    private String lineSeparator;
    private TransactionalWriter writer = null;

    public void open(Serializable checkpoint) throws Exception {
        if (this.output == null) {
            throw new BatchRuntimeException("Can't find any output");
        }
        File file = new File(this.output);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new BatchRuntimeException("Can't create parent for " + this.output);
        }
        if (this.lineSeparator == null) {
            this.lineSeparator = System.getProperty("line.separator", "\n");
        }
        this.writer = new TransactionalWriter(file, this.encoding, checkpoint);
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            String string = this.preWrite(item);
            if (string == null) continue;
            String toWrite = string + this.lineSeparator;
            this.writer.write(toWrite);
        }
        this.writer.flush();
    }

    protected String preWrite(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.writer.position());
    }
}

