/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.csv.mapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.batchee.csv.mapper.CoercingConverter;

public class Primitives
implements CoercingConverter {
    public static final CoercingConverter INSTANCE;

    public static Object primitiveDefaultValue(Class<?> type) {
        return Mapping.PRIMITIVE_DEFAULTS.get(type);
    }

    private static void register(Class<?> wrapper, Class<?> primitive, Object defaultValue, Converter converter) {
        Mapping.WRAPPERS.put(wrapper, primitive);
        Mapping.CONVERTERS.put(wrapper, converter);
        Mapping.PRIMITIVE_DEFAULTS.put(primitive, defaultValue);
        if (wrapper != Character.class) {
            try {
                Mapping.PRIMITIVES.put(primitive, wrapper.getMethod("valueOf", String.class));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Object valueFor(Class<?> type, String value) {
        Method valueOf = Mapping.PRIMITIVES.get(type);
        if (valueOf != null) {
            if (value == null || value.trim().isEmpty()) {
                return Mapping.PRIMITIVE_DEFAULTS.get(type);
            }
            try {
                return valueOf.invoke(null, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e.getCause());
            }
        }
        if (Character.TYPE == type) {
            if (value == null || value.trim().isEmpty()) {
                return Mapping.PRIMITIVE_DEFAULTS.get(type);
            }
            return Character.valueOf(value.charAt(0));
        }
        if (value == null) {
            return null;
        }
        Class<?> currentType = value.getClass();
        Class<?> primitive = Mapping.WRAPPERS.get(currentType);
        if (primitive != null && type == primitive) {
            return Mapping.CONVERTERS.get(currentType).convert(value);
        }
        return null;
    }

    static {
        Primitives.register(Boolean.class, Boolean.TYPE, false, new Converter(){

            @Override
            public Object convert(String o) {
                return Boolean.parseBoolean(o);
            }
        });
        Primitives.register(Integer.class, Integer.TYPE, 0, new Converter(){

            @Override
            public Object convert(String o) {
                return Integer.parseInt(o);
            }
        });
        Primitives.register(Short.class, Short.TYPE, (short)0, new Converter(){

            @Override
            public Object convert(String o) {
                return Short.parseShort(o);
            }
        });
        Primitives.register(Long.class, Long.TYPE, 0L, new Converter(){

            @Override
            public Object convert(String o) {
                return Long.parseLong(o);
            }
        });
        Primitives.register(Byte.class, Byte.TYPE, (byte)0, new Converter(){

            @Override
            public Object convert(String o) {
                return Byte.parseByte(o);
            }
        });
        Primitives.register(Float.class, Float.TYPE, Float.valueOf(0.0f), new Converter(){

            @Override
            public Object convert(String o) {
                return Float.valueOf(Float.parseFloat(o));
            }
        });
        Primitives.register(Double.class, Double.TYPE, 0.0, new Converter(){

            @Override
            public Object convert(String o) {
                return Double.parseDouble(o);
            }
        });
        Primitives.register(Character.class, Character.TYPE, Character.valueOf('\u0000'), new Converter(){

            @Override
            public Object convert(String o) {
                return o.length() == 0 ? null : Character.valueOf(o.charAt(0));
            }
        });
        INSTANCE = new Primitives();
    }

    private static final class Mapping {
        private static final Map<Class<?>, Method> PRIMITIVES = new HashMap();
        private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = new HashMap();
        private static final Map<Class<?>, Class<?>> WRAPPERS = new HashMap();
        private static final Map<Class<?>, Converter> CONVERTERS = new HashMap();

        private Mapping() {
        }
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

