/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.csv;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.batchee.csv.CSVFormatFactory;
import org.apache.batchee.csv.CsvWriterMapper;
import org.apache.batchee.csv.mapper.DefaultMapper;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.locator.BeanLocator;
import org.apache.batchee.extras.transaction.TransactionalWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

@Documentation(value="Writes a CSV file using commons-csv.")
public class CommonsCsvWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="format to use (Default, RFC4180, Excel, TDF, MySQL)")
    private String format;
    @Inject
    @BatchProperty
    @Documentation(value="file to write")
    private String output;
    @Inject
    @BatchProperty
    @Documentation(value="output encoding")
    private String encoding;
    @Inject
    @BatchProperty
    @Documentation(value="record mapper if mapping is null")
    private String mapper;
    @Inject
    @BatchProperty
    @Documentation(value="mapping type if mapper is null")
    private String mapping;
    @Inject
    @BatchProperty
    @Documentation(value="locator to lookup the mapper")
    private String locator;
    @Inject
    @BatchProperty
    @Documentation(value="is missing column names allowed")
    private String allowMissingColumnNames;
    @Inject
    @BatchProperty
    @Documentation(value="delimiter of the file")
    private String delimiter;
    @Inject
    @BatchProperty
    @Documentation(value="quote character")
    private String quoteCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="quote mode (ALL, MINIMAL, NON_NUMERIC, NONE)")
    private String quoteMode;
    @Inject
    @BatchProperty
    @Documentation(value="comment marker")
    private String commentMarker;
    @Inject
    @BatchProperty
    @Documentation(value="escape character")
    private String escapeCharacter;
    @Inject
    @BatchProperty
    @Documentation(value="should the parser ignore surrounding spaces")
    private String ignoreSurroundingSpaces;
    @Inject
    @BatchProperty
    @Documentation(value="should empty lines be skipped")
    private String ignoreEmptyLines;
    @Inject
    @BatchProperty
    @Documentation(value="record separator")
    private String recordSeparator;
    @Inject
    @BatchProperty
    @Documentation(value="string replacement for null")
    private String nullString;
    @Inject
    @BatchProperty
    @Documentation(value="header comments")
    private String headerComments;
    @Inject
    @BatchProperty
    @Documentation(value="headers")
    private String header;
    @Inject
    @BatchProperty
    @Documentation(value="should headers be skipped")
    private String skipHeaderRecord;
    @Inject
    @BatchProperty
    @Documentation(value="should headers be written")
    private String writeHeaders;
    private CSVPrinter writer;
    private BeanLocator.LocatorInstance<CsvWriterMapper> mapperInstance;
    private TransactionalWriter transactionalWriter;

    public void open(Serializable checkpoint) throws Exception {
        DefaultMapper defaultMapper;
        DefaultMapper defaultMapper2 = defaultMapper = this.mapping != null ? new DefaultMapper(Thread.currentThread().getContextClassLoader().loadClass(this.mapping)) : null;
        BeanLocator.LocatorInstance locatorInstance = this.mapper == null ? (defaultMapper != null ? new BeanLocator.LocatorInstance(defaultMapper, null) : null) : (this.mapperInstance = BeanLocator.Finder.get((String)this.locator).newInstance(CsvWriterMapper.class, this.mapper));
        if ((this.header == null || this.header.isEmpty()) && Boolean.parseBoolean(this.writeHeaders) && DefaultMapper.class.isInstance(this.mapperInstance.getValue()) && checkpoint == null) {
            this.header = this.toListString(((DefaultMapper)DefaultMapper.class.cast(this.mapperInstance.getValue())).getHeaders());
        }
        CSVFormat format = this.newFormat();
        File file = new File(this.output);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Cant create " + String.valueOf(file));
        }
        this.transactionalWriter = new TransactionalWriter(file, this.encoding, checkpoint);
        this.writer = format.print((Appendable)this.transactionalWriter);
    }

    private String toListString(Iterable<String> headers) {
        StringBuilder b = new StringBuilder();
        for (String s : headers) {
            boolean quote = s.contains(",");
            if (quote) {
                b.append('\"');
            }
            b.append(s);
            if (quote) {
                b.append('\"');
            }
            b.append(",");
        }
        if (b.length() > 0) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    public void writeItems(List<Object> list) throws Exception {
        for (Object o : list) {
            if (CSVRecord.class.isInstance(o)) {
                this.writer.printRecord((Iterable)CSVRecord.class.cast(o));
                continue;
            }
            if (Iterable.class.isInstance(o)) {
                this.writer.printRecord((Iterable)Iterable.class.cast(o));
                continue;
            }
            if (this.mapperInstance != null) {
                this.writer.printRecord(((CsvWriterMapper)this.mapperInstance.getValue()).toRecord(o));
                continue;
            }
            throw new IllegalStateException("No way to write " + String.valueOf(o) + ". Does it implement Iterable<String> or did you set up a mapper?");
        }
        this.writer.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.transactionalWriter.position());
    }

    public void close() throws Exception {
        this.mapperInstance.release();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    protected CSVFormat newFormat() {
        return CSVFormatFactory.newFormat(this.format, this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.writeHeaders);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFormat(CSVFormat.Predefined predefined) {
        this.format = predefined.name();
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public void setAllowMissingColumnNames(String allowMissingColumnNames) {
        this.allowMissingColumnNames = allowMissingColumnNames;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setQuoteMode(String quoteMode) {
        this.quoteMode = quoteMode;
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public void setIgnoreSurroundingSpaces(String ignoreSurroundingSpaces) {
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
    }

    public void setIgnoreEmptyLines(String ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public void setHeaderComments(String headerComments) {
        this.headerComments = headerComments;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setSkipHeaderRecord(String skipHeaderRecord) {
        this.skipHeaderRecord = skipHeaderRecord;
    }

    public void setWriteHeaders(String readHeaders) {
        this.writeHeaders = readHeaders;
    }

    public void writeHeaders() {
        this.writeHeaders = "true";
    }
}

