/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import java.util.LinkedList;
import java.util.Set;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.api.Command;
import org.apache.commons.lang3.StringUtils;

@Command(name="status", description="list last batches statuses")
public class Status
extends JobOperatorCommand {
    @Override
    public void doRun() {
        JobOperator operator = this.operator();
        Set names = operator.getJobNames();
        if (names == null || names.isEmpty()) {
            this.info("No job");
        } else {
            this.info("     Name   \t|\texecution id\t|\tbatch status\t|\texit status\t|\tstart time\t|\tend time");
            for (String name : names) {
                try {
                    JobExecution exec = (JobExecution)new LinkedList(operator.getJobExecutions((JobInstance)new LinkedList(operator.getJobInstances(name, operator.getJobInstanceCount(name) - 1, 2)).getLast())).getLast();
                    this.info(String.format("%s\t|\t%12d\t|\t%s\t|\t%s\t|\t%tc\t|\t%tc", StringUtils.leftPad((String)name, (int)12), exec.getExecutionId(), StringUtils.leftPad((String)(exec.getBatchStatus() != null ? exec.getBatchStatus().toString() : "null"), (int)12), StringUtils.leftPad((String)exec.getExitStatus(), (int)11), exec.getStartTime(), exec.getEndTime()));
                }
                catch (NoSuchJobException noSuchJobException) {}
            }
        }
    }
}

