/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import java.util.List;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.StepExecutions;
import org.apache.batchee.cli.command.api.Command;
import org.apache.batchee.cli.command.api.Option;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.commons.lang3.StringUtils;

@Command(name="executions", description="list executions")
public class Executions
extends JobOperatorCommand {
    @Option(name="id", description="instance id", required=true)
    private long id;
    @Option(name="showSteps", description="if steps should be dumped as well")
    private boolean steps;

    @Override
    public void doRun() {
        JobOperator operator = this.operator();
        List executions = operator.getJobExecutions((JobInstance)new JobInstanceImpl(this.id));
        if (!executions.isEmpty()) {
            this.info("Executions of " + ((JobExecution)executions.iterator().next()).getJobName() + " for instance " + this.id);
        }
        this.info("execution id\t|\tbatch status\t|\texit status\t|\tstart time\t|\tend time");
        for (JobExecution exec : executions) {
            this.info(String.format("%12d\t|\t%s\t|\t%s\t|\t%tc\t|\t%tc", exec.getExecutionId(), StringUtils.leftPad((String)(exec.getBatchStatus() != null ? exec.getBatchStatus().toString() : "null"), (int)12), StringUtils.leftPad((String)exec.getExitStatus(), (int)11), exec.getStartTime(), exec.getEndTime()));
        }
        if (this.steps) {
            new StepExecutions().withOperator(operator).withId(this.id).run();
        }
    }
}

