/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batchee.cli.command.SocketConfigurableCommand;
import org.apache.batchee.cli.command.api.Option;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.commons.io.IOUtils;

public abstract class SocketCommand
extends SocketConfigurableCommand {
    @Option(name="timeout", description="timeout for socket case")
    private int timeout = 60000;

    protected boolean shouldUseSocket() {
        return this.baseUrl == null;
    }

    protected abstract String command();

    protected abstract void defaultRun();

    protected void sendCommand() {
        if (this.adminSocket < 0) {
            throw new BatchContainerRuntimeException("specify -socket to be able to run this command");
        }
        Socket socket = null;
        socket = new Socket("localhost", this.adminSocket);
        socket.setSoTimeout(this.timeout);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Integer> answer = new AtomicReference<Integer>();
        new AnswerThread(socket, answer, latch).start();
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(this.command().getBytes());
        outputStream.flush();
        socket.shutdownOutput();
        try {
            latch.await(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.info("no answer after " + this.timeout + "ms");
            IOUtils.closeQuietly((Socket)socket);
            return;
        }
        try {
            if (answer.get() != 0) {
                this.info("unexpected answer: " + answer.get());
            }
        }
        catch (IOException e) {
            try {
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Socket)socket);
    }

    @Override
    public void doRun() {
        if (this.shouldUseSocket()) {
            this.sendCommand();
        } else {
            this.defaultRun();
        }
        this.postCommand();
    }

    protected abstract void postCommand();

    private static class AnswerThread
    extends Thread {
        private final Socket socket;
        private final AtomicReference<Integer> answer;
        private final CountDownLatch latch;

        public AnswerThread(Socket socket, AtomicReference<Integer> answer, CountDownLatch latch) {
            this.socket = socket;
            this.answer = answer;
            this.latch = latch;
            this.setName("batchee-answer-thread");
        }

        @Override
        public void run() {
            try {
                this.answer.set(this.socket.getInputStream().read());
            }
            catch (IOException e) {
                this.answer.set(-1);
            }
            this.latch.countDown();
        }
    }
}

