/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.api.Command;

@Command(name="names", description="list known batches")
public class Names
extends JobOperatorCommand {
    @Override
    public void doRun() {
        Enumeration<URL> resources;
        Set names = this.operator().getJobNames();
        this.info("");
        this.info("names");
        this.info("-----");
        if (names != null) {
            for (String name : names) {
                this.info(name);
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            resources = loader.getResources("META-INF/batch-jobs");
        }
        catch (IOException e) {
            return;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            File file = Names.toFile(url);
            if (file == null) continue;
            if (file.isDirectory()) {
                this.findInDirectory(file);
                continue;
            }
            this.findInJar(file);
        }
    }

    private void findInJar(File file) {
        JarFile jar;
        Pattern pattern = Pattern.compile("META\\-INF/batch-jobs/\\(*\\).xml");
        try {
            jar = new JarFile(file);
        }
        catch (IOException e) {
            return;
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Matcher matcher = pattern.matcher(entry.getName());
            if (!matcher.matches()) continue;
            this.info(matcher.group(1) + "*");
        }
    }

    private void findInDirectory(File file) {
        String[] batches = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (batches != null) {
            for (String batch : batches) {
                this.info(batch + "*");
            }
        }
    }

    private static File toFile(URL url) {
        String externalForm = url.toExternalForm();
        File file = "jar".equals(url.getProtocol()) ? new File(externalForm.substring("jar:".length(), externalForm.lastIndexOf(33))) : ("file".equals(url.getProtocol()) ? new File(externalForm.substring("file:".length())) : null);
        return file;
    }
}

