/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.camel;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.batchee.camel.CamelBridge;
import org.apache.batchee.doc.api.Documentation;

@Documentation(value="Uses a camel consumer as reader.")
public class CamelItemReader
implements ItemReader {
    @Inject
    @BatchProperty
    @Documentation(value="Endpoint URI")
    private String endpoint;
    @Inject
    @BatchProperty(name="timeout")
    @Documentation(value="Timeout after which we consider the consumption is done")
    private String timeoutStr;
    @Inject
    @BatchProperty
    @Documentation(value="Consumer stream type")
    private String expectedClass;
    @Inject
    @BatchProperty
    @Documentation(value="Locator for the consumer template")
    private String templateLocator;

    public Object readItem() throws Exception {
        Class<?> expected = this.expectedClass != null ? Thread.currentThread().getContextClassLoader().loadClass(this.expectedClass) : null;
        long timeout = this.timeoutStr == null ? 1000L : (long)Integer.parseInt(this.timeoutStr);
        return CamelBridge.receive(this.templateLocator, this.endpoint, timeout, expected);
    }

    public void close() throws Exception {
    }

    public void open(Serializable checkpoint) throws Exception {
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

