/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.beanio;

import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import org.apache.batchee.beanio.BeanIOs;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.TransactionalWriter;
import org.beanio.BeanWriter;

@Documentation(value="Reads a file using BeanIO.")
public class BeanIOWriter
implements ItemWriter {
    @Inject
    @BatchProperty(name="file")
    @Documentation(value="The file to write")
    protected String filePath;
    @Inject
    @BatchProperty
    @Documentation(value="The BeanIO stream name")
    protected String streamName;
    @Inject
    @BatchProperty
    @Documentation(value="The configuration path in the classpath")
    protected String configuration;
    @Inject
    @BatchProperty
    @Documentation(value="The output encoding")
    protected String encoding;
    private BeanWriter writer;
    private TransactionalWriter transactionalWriter;

    public void open(Serializable checkpoint) throws Exception {
        File file;
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (!(file = new File(this.filePath)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new BatchRuntimeException(file.getParentFile().getAbsolutePath());
        }
        this.transactionalWriter = new TransactionalWriter(file, this.encoding, checkpoint);
        this.writer = BeanIOs.open(this.filePath, this.streamName, this.configuration).createWriter(this.streamName, (Writer)this.transactionalWriter);
    }

    public void close() throws Exception {
        this.writer.close();
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            this.writer.write(item);
        }
        this.transactionalWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.transactionalWriter.position());
    }
}

