/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Hashtable;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.kernel.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSConnectionFactoryManager;
import org.apache.axis2.transport.jms.JMSMessageSender;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.iowrappers.BytesMessageOutputStream;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.WriterOutputStream;

public class JMSSender
extends AbstractTransportSender
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "jms";
    private JMSConnectionFactoryManager connFacManager;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        this.connFacManager = new JMSConnectionFactoryManager((ParameterInclude)transportOut);
        this.log.info((Object)"JMS Transport Sender initialized...");
    }

    public void stop() {
        this.connFacManager.stop();
        super.stop();
    }

    private JMSConnectionFactory getJMSConnectionFactory(JMSOutTransportInfo trpInfo) {
        Hashtable<String, String> props = trpInfo.getProperties();
        if (trpInfo.getProperties() != null) {
            String jmsConnectionFactoryName = (String)props.get("transport.jms.ConnectionFactory");
            if (jmsConnectionFactoryName != null) {
                return this.connFacManager.getJMSConnectionFactory(jmsConnectionFactoryName);
            }
            JMSConnectionFactory fac = this.connFacManager.getJMSConnectionFactory(props);
            if (fac == null) {
                fac = this.connFacManager.getJMSConnectionFactory("default");
            }
            return fac;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        JMSConnectionFactory jmsConnectionFactory = null;
        JMSOutTransportInfo jmsOut = null;
        JMSMessageSender messageSender = null;
        if (targetAddress != null) {
            jmsOut = new JMSOutTransportInfo(targetAddress);
            jmsConnectionFactory = this.getJMSConnectionFactory(jmsOut);
            if (jmsConnectionFactory != null) {
                messageSender = new JMSMessageSender(jmsConnectionFactory, targetAddress);
            } else {
                try {
                    messageSender = jmsOut.createJMSSender();
                }
                catch (JMSException e) {
                    this.handleException("Unable to create a JMSMessageSender for : " + String.valueOf(outTransportInfo), (Exception)((Object)e));
                }
            }
        } else if (outTransportInfo != null && outTransportInfo instanceof JMSOutTransportInfo) {
            jmsOut = (JMSOutTransportInfo)outTransportInfo;
            try {
                messageSender = jmsOut.createJMSSender();
            }
            catch (JMSException e) {
                this.handleException("Unable to create a JMSMessageSender for : " + String.valueOf(outTransportInfo), (Exception)((Object)e));
            }
        }
        String contentTypeProperty = (String)msgCtx.getProperty("transport.jms.ContentTypeProperty");
        if (contentTypeProperty == null) {
            contentTypeProperty = jmsOut.getContentTypeProperty();
        }
        Session session = messageSender.getSession();
        synchronized (session) {
            try {
                this.sendOverJMS(msgCtx, messageSender, contentTypeProperty, jmsConnectionFactory, jmsOut);
            }
            finally {
                messageSender.close();
            }
        }
    }

    private void sendOverJMS(MessageContext msgCtx, JMSMessageSender messageSender, String contentTypeProperty, JMSConnectionFactory jmsConnectionFactory, JMSOutTransportInfo jmsOut) throws AxisFault {
        Message message = null;
        String correlationId = null;
        try {
            message = this.createJMSMessage(msgCtx, messageSender.getSession(), contentTypeProperty);
        }
        catch (JMSException e) {
            this.handleException("Error creating a JMS message from the message context", (Exception)((Object)e));
        }
        boolean waitForResponse = this.waitForSynchronousResponse(msgCtx);
        Destination replyDestination = jmsOut.getReplyDestination();
        if (waitForResponse) {
            String replyDestType;
            String replyDestName = (String)msgCtx.getProperty("JMS_REPLY_TO");
            if (replyDestName == null && jmsConnectionFactory != null) {
                replyDestName = jmsConnectionFactory.getReplyToDestination();
            }
            if ((replyDestType = (String)msgCtx.getProperty("JMS_REPLY_TO_TYPE")) == null && jmsConnectionFactory != null) {
                replyDestType = jmsConnectionFactory.getReplyDestinationType();
            }
            if (replyDestName != null) {
                replyDestination = jmsConnectionFactory != null ? jmsConnectionFactory.getDestination(replyDestName, replyDestType) : jmsOut.getReplyDestination(replyDestName);
            }
            replyDestination = JMSUtils.setReplyDestination(replyDestination, messageSender.getSession(), message);
        }
        try {
            messageSender.send(message, msgCtx);
            this.metrics.incrementMessagesSent(msgCtx);
        }
        catch (AxisJMSException e) {
            this.metrics.incrementFaultsSending();
            this.handleException("Error sending JMS message", e);
        }
        try {
            this.metrics.incrementBytesSent(msgCtx, JMSUtils.getMessageSize(message));
        }
        catch (JMSException e) {
            this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
        }
        if (waitForResponse) {
            try {
                messageSender.getConnection().start();
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                String jmsCorrelationID = message.getJMSCorrelationID();
                correlationId = jmsCorrelationID != null && jmsCorrelationID.length() > 0 ? jmsCorrelationID : message.getJMSMessageID();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.waitForResponseAndProcess(messageSender.getSession(), replyDestination, msgCtx, correlationId, contentTypeProperty);
        }
    }

    private void waitForResponseAndProcess(Session session, Destination replyDestination, MessageContext msgCtx, String correlationId, String contentTypeProperty) throws AxisFault {
        block9: {
            try {
                Message reply;
                MessageConsumer consumer = JMSUtils.createConsumer(session, replyDestination, "JMSCorrelationID = '" + correlationId + "'");
                long timeout = 30000L;
                String waitReply = (String)msgCtx.getProperty("JMS_WAIT_REPLY");
                if (waitReply != null) {
                    timeout = Long.valueOf(waitReply);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Waiting for a maximum of " + timeout + "ms for a response message to destination : " + String.valueOf(replyDestination) + " with JMS correlation ID : " + correlationId));
                }
                if ((reply = consumer.receive(timeout)) != null) {
                    this.metrics.incrementMessagesReceived();
                    try {
                        this.metrics.incrementBytesReceived(JMSUtils.getMessageSize(reply));
                    }
                    catch (JMSException e) {
                        this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
                    }
                    try {
                        this.processSyncResponse(msgCtx, reply, contentTypeProperty);
                        this.metrics.incrementMessagesReceived();
                        break block9;
                    }
                    catch (AxisFault e) {
                        this.metrics.incrementFaultsReceiving();
                        throw e;
                    }
                }
                this.log.warn((Object)("Did not receive a JMS response within " + timeout + " ms to destination : " + String.valueOf(replyDestination) + " with JMS correlation ID : " + correlationId));
                this.metrics.incrementTimeoutsReceiving();
            }
            catch (JMSException e) {
                this.metrics.incrementFaultsReceiving();
                this.handleException("Error creating a consumer, or receiving a synchronous reply for outgoing MessageContext ID : " + msgCtx.getMessageID() + " and reply Destination : " + String.valueOf(replyDestination), (Exception)((Object)e));
            }
        }
    }

    private Message createJMSMessage(MessageContext msgContext, Session session, String contentTypeProperty) throws JMSException, AxisFault {
        BytesMessage message = null;
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        String jmsPayloadType = this.guessMessageType(msgContext);
        if (jmsPayloadType == null) {
            BytesMessageOutputStream out;
            StringWriter sw;
            boolean useBytesMessage;
            OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
            MessageFormatter messageFormatter = null;
            try {
                messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
            }
            catch (AxisFault axisFault) {
                throw new JMSException("Unable to get the message formatter to use");
            }
            String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
            boolean bl = useBytesMessage = msgType != null && "JMS_BYTE_MESSAGE".equals(msgType) || contentType.indexOf("multipart/related") > -1;
            if (useBytesMessage) {
                BytesMessage bytesMsg = session.createBytesMessage();
                sw = null;
                out = new BytesMessageOutputStream(bytesMsg);
                message = bytesMsg;
            } else {
                sw = new StringWriter();
                try {
                    out = new WriterOutputStream((Writer)sw, format.getCharSetEncoding());
                }
                catch (UnsupportedCharsetException ex) {
                    this.handleException("Unsupported encoding " + format.getCharSetEncoding(), ex);
                    return null;
                }
            }
            try {
                messageFormatter.writeTo(msgContext, format, (OutputStream)out, true);
                out.close();
            }
            catch (IOException e) {
                this.handleException("IO Error while creating BytesMessage", e);
            }
            if (!useBytesMessage) {
                TextMessage txtMsg = session.createTextMessage();
                txtMsg.setText(sw.toString());
                message = txtMsg;
            }
            if (contentTypeProperty != null) {
                message.setStringProperty(contentTypeProperty, contentType);
            }
        } else if ("JMS_BYTE_MESSAGE".equals(jmsPayloadType)) {
            Blob blob;
            BytesMessage bytesMsg = message = session.createBytesMessage();
            OMElement wrapper = msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_BINARY_WRAPPER);
            OMNode omNode = wrapper.getFirstOMChild();
            if (omNode != null && omNode instanceof OMText && (blob = ((OMText)omNode).getBlob()) != null) {
                try {
                    blob.writeTo((OutputStream)new BytesMessageOutputStream(bytesMsg));
                }
                catch (IOException e) {
                    this.handleException("Error serializing binary content of element : " + String.valueOf(BaseConstants.DEFAULT_BINARY_WRAPPER), e);
                }
            }
        } else if ("JMS_TEXT_MESSAGE".equals(jmsPayloadType)) {
            message = session.createTextMessage();
            TextMessage txtMsg = (TextMessage)message;
            txtMsg.setText(msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_TEXT_WRAPPER).getText());
        }
        String correlationId = this.getProperty(msgContext, "JMS_COORELATION_ID");
        if (correlationId == null && msgContext.getRelatesTo() != null) {
            correlationId = msgContext.getRelatesTo().getValue();
        }
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty((Message)message, msgContext, "SOAPAction");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        JMSUtils.setTransportHeaders(msgContext, (Message)message);
        return message;
    }

    private String guessMessageType(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_BYTE_MESSAGE";
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_TEXT_MESSAGE";
            }
        }
        return null;
    }

    private void processSyncResponse(MessageContext outMsgCtx, Message message, String contentTypeProperty) throws AxisFault {
        MessageContext responseMsgCtx = this.createResponseMessageContext(outMsgCtx);
        JMSUtils.loadTransportHeaders(message, responseMsgCtx);
        String contentType = contentTypeProperty == null ? null : JMSUtils.getProperty(message, contentTypeProperty);
        try {
            JMSUtils.setSOAPEnvelope(message, responseMsgCtx, contentType);
        }
        catch (JMSException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        this.handleIncomingMessage(responseMsgCtx, JMSUtils.getTransportHeaders(message), JMSUtils.getProperty(message, "SOAPAction"), contentType);
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                this.log.warn((Object)("Couldn't set message property : " + key + " = " + value), (Throwable)e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }
}

