/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.impl.httpclient5;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.mime.Header;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.axis2.transport.http.HTTPAuthenticator;
import org.apache.axis2.transport.http.Request;
import org.apache.axis2.transport.http.impl.httpclient5.AxisRequestEntityImpl;
import org.apache.axis2.transport.http.impl.httpclient5.HTTPProxyConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.StandardAuthScheme;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Timeout;

final class RequestImpl
implements Request {
    private static final String[] COOKIE_HEADER_NAMES = new String[]{"Set-Cookie", "Set-Cookie2"};
    private static final Log log = LogFactory.getLog(RequestImpl.class);
    private final HttpClient httpClient;
    private final MessageContext msgContext;
    private final HttpUriRequestBase httpRequestMethod;
    private final HttpHost httpHost;
    private final RequestConfig.Builder requestConfig;
    private final HttpClientContext clientContext;
    private ClassicHttpResponse response;
    private final String methodName;
    private String path;
    private String scheme;
    private URIAuthority authority;
    private URI requestUri;
    private ProtocolVersion version;
    private HeaderGroup headerGroup;
    private boolean absoluteRequestUri;

    RequestImpl(HttpClient httpClient, MessageContext msgContext, String methodName, URI requestUri, AxisRequestEntity requestEntity) throws AxisFault {
        String protocol;
        this.httpClient = httpClient;
        this.methodName = methodName;
        this.msgContext = msgContext;
        this.requestUri = requestUri;
        this.authority = this.authority;
        this.requestConfig = RequestConfig.custom();
        this.clientContext = HttpClientContext.create();
        this.httpRequestMethod = new HttpUriRequestBase(this.methodName, this.requestUri);
        if (requestEntity != null) {
            this.httpRequestMethod.setEntity((HttpEntity)new AxisRequestEntityImpl(requestEntity));
        }
        try {
            this.httpRequestMethod.setUri(requestUri);
        }
        catch (Exception ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        int port = requestUri.getPort();
        if (this.httpRequestMethod.getVersion() != null && this.httpRequestMethod.getVersion().getProtocol() != null) {
            protocol = this.httpRequestMethod.getVersion().getProtocol();
            log.debug((Object)("Received protocol from this.httpRequestMethod.getVersion().getProtocol(): " + protocol));
        } else if (requestUri.getScheme() != null) {
            protocol = requestUri.getScheme();
            log.debug((Object)("Received protocol from requestUri.getScheme(): " + protocol));
        } else {
            protocol = "http";
            log.warn((Object)("Cannot find protocol, using default as http on requestUri: " + requestUri));
        }
        if (port == -1) {
            if ("http".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol)) {
                port = 443;
            }
        }
        this.httpHost = new HttpHost(protocol, requestUri.getHost(), port);
    }

    @Override
    public void enableHTTP10() {
        this.httpRequestMethod.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
    }

    @Override
    public void setHeader(String name, String value) {
        this.httpRequestMethod.setHeader(name, (Object)value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.httpRequestMethod.addHeader(name, (Object)value);
    }

    private static Header[] convertHeaders(org.apache.hc.core5.http.Header[] headers) {
        Header[] result = new Header[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = new Header(headers[i].getName(), headers[i].getValue());
        }
        int size = result != null ? result.length : 0;
        return result;
    }

    @Override
    public Header[] getRequestHeaders() {
        int size = this.httpRequestMethod.getHeaders() != null ? this.httpRequestMethod.getHeaders().length : 0;
        return RequestImpl.convertHeaders(this.httpRequestMethod.getHeaders());
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.requestConfig.setConnectTimeout(Timeout.ofMilliseconds((long)timeout));
        this.requestConfig.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeout));
    }

    @Override
    public void setResponseTimeout(int timeout) {
        this.requestConfig.setResponseTimeout(Timeout.ofMilliseconds((long)timeout));
    }

    @Override
    public int getStatusCode() {
        return this.response.getCode();
    }

    @Override
    public String getStatusText() {
        return this.response.getReasonPhrase();
    }

    @Override
    public String getResponseHeader(String name) {
        org.apache.hc.core5.http.Header header = this.response.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public Header[] getResponseHeaders() {
        return RequestImpl.convertHeaders(this.response.getHeaders());
    }

    @Override
    public Map<String, String> getCookies() {
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (String name : COOKIE_HEADER_NAMES) {
            for (org.apache.hc.core5.http.Header header : this.response.getHeaders()) {
                cookies.put(header.getName(), header.getValue());
            }
        }
        return cookies;
    }

    @Override
    public InputStream getResponseContent() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity == null ? null : entity.getContent();
    }

    @Override
    public void execute() throws IOException {
        org.apache.hc.core5.http.Header[] headers;
        String cookiePolicy;
        this.populateHostConfiguration();
        if (this.msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            this.httpRequestMethod.addHeader("Accept-Encoding", (Object)"gzip");
        }
        if ((cookiePolicy = (String)this.msgContext.getProperty("COOKIE_POLICY")) != null) {
            this.requestConfig.setCookieSpec(cookiePolicy);
        }
        this.clientContext.setRequestConfig(this.requestConfig.build());
        this.httpRequestMethod.removeHeaders("Content-Length");
        for (org.apache.hc.core5.http.Header header : headers = this.httpRequestMethod.getHeaders()) {
            log.debug((Object)("sending HTTP request header: " + header));
        }
        this.response = this.httpClient.executeOpen(this.httpHost, (ClassicHttpRequest)this.httpRequestMethod, (HttpContext)this.clientContext);
    }

    @Override
    public void releaseConnection() {
        log.trace((Object)("Cleaning response : " + this.response));
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                log.error((Object)("Error while cleaning response : " + this.response), (Throwable)e);
            }
        }
    }

    private void populateHostConfiguration() throws AxisFault {
        try {
            if (HTTPProxyConfigurator.isProxyEnabled(this.msgContext, this.requestUri.toURL())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Configuring HTTP proxy.");
                }
                HTTPProxyConfigurator.configure(this.msgContext, this.requestConfig, this.clientContext);
            }
        }
        catch (MalformedURLException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
    }

    @Override
    public void enableAuthentication(HTTPAuthenticator authenticator) {
        List schemes;
        this.requestConfig.setAuthenticationEnabled(true);
        String username = authenticator.getUsername();
        String password = authenticator.getPassword();
        String host = authenticator.getHost();
        String domain = authenticator.getDomain();
        int port = authenticator.getPort();
        String realm = authenticator.getRealm();
        CredentialsProvider credsProvider = this.clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            Object creds;
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            this.clientContext.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            if (host != null) {
                creds = domain != null ? new NTCredentials(username, password.toCharArray(), host, domain) : new UsernamePasswordCredentials(username, password.toCharArray());
                basicCredentialsProvider.setCredentials(new AuthScope(null, host, port, realm, null), (Credentials)creds);
            } else if (domain != null) {
                creds = new NTCredentials(username, password.toCharArray(), null, domain);
                basicCredentialsProvider.setCredentials(new AuthScope(null, null, port, realm, null), (Credentials)creds);
            } else {
                creds = new UsernamePasswordCredentials(username, password.toCharArray());
                basicCredentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)creds);
            }
        }
        if ((schemes = authenticator.getAuthSchemes()) != null && schemes.size() > 0) {
            ArrayList<Object> authPrefs = new ArrayList<Object>(3);
            for (int i = 0; i < schemes.size(); ++i) {
                if (schemes.get(i) instanceof StandardAuthScheme) {
                    authPrefs.add(schemes.get(i));
                    continue;
                }
                String scheme = (String)schemes.get(i);
                authPrefs.add(authenticator.getAuthPolicyPref(scheme));
            }
            this.requestConfig.setTargetPreferredAuthSchemes(authPrefs);
        }
    }
}

