/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpService;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.HttpFactory;
import org.apache.axis2.transport.http.server.HttpServiceProcessor;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.axis2.transport.http.server.RequestSessionCookie;
import org.apache.axis2.transport.http.server.ResponseSessionCookie;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;

public class DefaultHttpConnectionManager
implements HttpConnectionManager {
    private static Log LOG = LogFactory.getLog(DefaultHttpConnectionManager.class);
    private final ConfigurationContext configurationContext;
    private final Executor executor;
    private final WorkerFactory workerfactory;
    private final Http1Config http1Config;
    private final List processors;
    private HttpFactory httpFactory = null;

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, Http1Config http1Config) {
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor may not be null");
        }
        if (workerfactory == null) {
            throw new IllegalArgumentException("Worker factory may not be null");
        }
        this.configurationContext = configurationContext;
        this.executor = executor;
        this.workerfactory = workerfactory;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.processors = new LinkedList();
    }

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, Http1Config http1Config, HttpFactory httpFactory) {
        this(configurationContext, executor, workerfactory, http1Config);
        this.httpFactory = httpFactory;
    }

    private synchronized void cleanup() {
        Iterator i = this.processors.iterator();
        while (i.hasNext()) {
            IOProcessor processor = (IOProcessor)i.next();
            if (!processor.isDestroyed()) continue;
            i.remove();
        }
    }

    private synchronized void addProcessor(IOProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("The processor can't be null");
        }
        this.processors.add(processor);
    }

    synchronized void removeProcessor(IOProcessor processor) throws NullPointerException {
        if (processor == null) {
            throw new NullPointerException("The processor can't be null");
        }
        this.processors.remove(processor);
    }

    @Override
    public void process(AxisHttpConnection conn) {
        DefaultClassicHttpResponseFactory responseFactory;
        ConnectionReuseStrategy connStrategy;
        HttpProcessor httpProcessor;
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        this.cleanup();
        if (this.httpFactory != null) {
            httpProcessor = this.httpFactory.newHttpProcessor();
            connStrategy = this.httpFactory.newConnStrategy();
            responseFactory = this.httpFactory.newResponseFactory();
        } else {
            HttpProcessorBuilder b = HttpProcessorBuilder.create();
            b.addAll(new HttpRequestInterceptor[]{new RequestSessionCookie()});
            b.addAll(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl(), new ResponseSessionCookie()});
            httpProcessor = b.build();
            connStrategy = new DefaultConnectionReuseStrategy();
            responseFactory = DefaultClassicHttpResponseFactory.INSTANCE;
        }
        AxisHttpService httpService = new AxisHttpService(httpProcessor, this.http1Config, connStrategy, null, responseFactory, this.configurationContext, this.workerfactory.newWorker());
        IOProcessorCallback callback = new IOProcessorCallback(){

            @Override
            public void completed(IOProcessor processor) {
                DefaultHttpConnectionManager.this.removeProcessor(processor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(processor + " terminated"));
                }
            }
        };
        HttpServiceProcessor processor = new HttpServiceProcessor(httpService, conn, callback);
        this.addProcessor(processor);
        this.executor.execute(processor);
    }

    @Override
    public synchronized void shutdown() {
        for (int i = 0; i < this.processors.size(); ++i) {
            IOProcessor processor = (IOProcessor)this.processors.get(i);
            processor.destroy();
        }
        this.processors.clear();
    }
}

