/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.RejectedExecutionException;
import org.apache.axis2.transport.http.server.AxisHttpConnectionImpl;
import org.apache.axis2.transport.http.server.ConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.io.SocketConfig;

public class DefaultConnectionListener
implements IOProcessor {
    private static Log LOG = LogFactory.getLog(DefaultConnectionListener.class);
    private volatile boolean destroyed = false;
    private final String scheme;
    private final int port;
    private final HttpConnectionManager connmanager;
    private final ConnectionListenerFailureHandler failureHandler;
    private final Http1Config http1Config;
    private final SocketConfig socketConfig;
    private ServerSocket serversocket = null;

    public DefaultConnectionListener(String scheme, int port, HttpConnectionManager connmanager, ConnectionListenerFailureHandler failureHandler, Http1Config http1Config, SocketConfig socketConfig) throws IOException {
        if (connmanager == null) {
            throw new IllegalArgumentException("Connection manager may not be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("Failure handler may not be null");
        }
        if (http1Config == null) {
            throw new IllegalArgumentException("http1Config may not be null");
        }
        if (socketConfig == null) {
            throw new IllegalArgumentException("socketConfig may not be null");
        }
        this.scheme = scheme;
        this.port = port;
        this.connmanager = connmanager;
        this.failureHandler = failureHandler;
        this.http1Config = http1Config;
        this.socketConfig = socketConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            DefaultConnectionListener defaultConnectionListener;
            block17: while (true) {
                while (!Thread.interrupted()) {
                    try {
                        if (this.serversocket == null || this.serversocket.isClosed()) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("Listening on port " + this.port));
                            }
                            defaultConnectionListener = this;
                            synchronized (defaultConnectionListener) {
                                this.serversocket = new ServerSocket(this.port);
                                this.serversocket.setReuseAddress(true);
                                this.notifyAll();
                            }
                        }
                        LOG.debug((Object)"Waiting for incoming HTTP connection");
                        Socket socket = this.serversocket.accept();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Incoming HTTP connection from " + socket.getRemoteSocketAddress()));
                        }
                        AxisHttpConnectionImpl conn = new AxisHttpConnectionImpl(this.scheme, socket, this.http1Config, this.socketConfig);
                        try {
                            this.connmanager.process(conn);
                            continue block17;
                        }
                        catch (RejectedExecutionException e) {
                            DefaultClassicHttpResponseFactory responseFactory = DefaultClassicHttpResponseFactory.INSTANCE;
                            conn.sendResponse((ClassicHttpResponse)responseFactory.newHttpResponse(503));
                        }
                    }
                    catch (InterruptedIOException ie) {
                        break block24;
                    }
                    catch (Throwable ex) {
                        if (Thread.interrupted()) {
                        } else if (this.failureHandler.failed(this, ex)) continue;
                        break block24;
                    }
                }
                break block24;
                {
                    continue block17;
                    break;
                }
                break;
            }
            finally {
                this.destroy();
                defaultConnectionListener = this;
                synchronized (defaultConnectionListener) {
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized void awaitSocketOpen() throws InterruptedException {
        while (this.serversocket == null && !this.destroyed) {
            this.wait();
        }
    }

    public synchronized int getPort() {
        return this.serversocket.getLocalPort();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.serversocket != null) {
            this.serversocket.close();
            this.serversocket = null;
        }
    }

    @Override
    public synchronized void destroy() {
        block2: {
            this.destroyed = true;
            try {
                this.close();
            }
            catch (IOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"I/O error closing listener", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }
}

