/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.util.activation.DataHandlerUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.kernel.http.util.URLTemplatingUtil;
import org.apache.axis2.transport.base.BaseConstants;

public class BinaryFormatter
implements MessageFormatter {
    private Blob getBlob(MessageContext messageContext) {
        OMNode omNode;
        OMElement firstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName()) && (omNode = firstChild.getFirstOMChild()) != null && omNode instanceof OMText) {
            return ((OMText)omNode).getBlob();
        }
        return null;
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        Blob blob = this.getBlob(messageContext);
        if (blob != null) {
            try {
                blob.writeTo(outputStream);
            }
            catch (IOException e) {
                throw new AxisFault("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER, (Throwable)e);
            }
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        Blob blob = this.getBlob(messageContext);
        if (blob != null) {
            return DataHandlerUtils.toDataHandler((Blob)blob).getContentType();
        }
        return null;
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        return URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)messageContext, (boolean)false);
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }

    public DataSource getDataSource(MessageContext messageContext, OMOutputFormat format, String soapAction) throws AxisFault {
        return DataHandlerUtils.toDataHandler((Blob)this.getBlob(messageContext)).getDataSource();
    }
}

