/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.resolver.AARBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.AARFileBasedURIResolver;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;

public class ServiceDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(ServiceDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;
    private String directory;

    @Override
    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    @Override
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        File deploymentFile = deploymentFileData.getFile();
        if (deploymentFile == null) {
            this.deployFromUrl(deploymentFileData);
            return;
        }
        boolean isDirectory = deploymentFile.isDirectory();
        StringWriter errorWriter = new StringWriter();
        ArchiveReader archiveReader = new ArchiveReader();
        Object serviceStatus = "";
        try {
            String serviceHierarchy;
            deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getServiceClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
            OMElement serviceMetaData = archiveReader.buildServiceDescription(deploymentFileData.getAbsolutePath(), this.configCtx, isDirectory);
            deploymentFileData.setServiceMetaData(serviceMetaData);
            Map<String, AxisService> serviceMap = this.executeServiceBuilderExtensions(deploymentFileData, this.configCtx);
            AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
            serviceGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
            ArrayList<AxisService> serviceList = archiveReader.processServiceGroup(serviceMetaData, deploymentFileData, serviceGroup, isDirectory, serviceMap, this.configCtx);
            URL location = deploymentFileData.getFile().toURI().toURL();
            if (location != null && (serviceHierarchy = Utils.getServiceHierarchy(location.getPath(), this.directory)) != null && !"".equals(serviceHierarchy)) {
                serviceGroup.setServiceGroupName(serviceHierarchy + serviceGroup.getServiceGroupName());
                for (AxisService axisService : serviceList) {
                    axisService.setName(serviceHierarchy + axisService.getName());
                }
            }
            DeploymentEngine.addServiceGroup(serviceGroup, serviceList, location, deploymentFileData, this.axisConfig);
            super.deploy(deploymentFileData);
        }
        catch (DeploymentException de) {
            de.printStackTrace();
            log.error((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), de.getMessage()), (Throwable)de);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            de.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw de;
        }
        catch (AxisFault axisFault) {
            log.error((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), axisFault.getMessage()), (Throwable)axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(axisFault);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                log.info((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(e);
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.info((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            t.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(new Exception(t));
        }
        finally {
            if (((String)serviceStatus).startsWith("Error:")) {
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), (String)serviceStatus);
            }
        }
    }

    public void deployFromUrl(DeploymentFileData deploymentFileData) throws DeploymentException {
        URL servicesURL = deploymentFileData.getUrl();
        if (servicesURL == null) {
            return;
        }
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        StringWriter errorWriter = new StringWriter();
        ArrayList<AxisService> servicelist = this.populateService(serviceGroup, servicesURL, DescriptionBuilder.getShortFileName(deploymentFileData.getName()));
        try {
            DeploymentEngine.addServiceGroup(serviceGroup, servicelist, servicesURL, null, this.axisConfig);
            if (!JavaUtils.isTrueExplicitly(serviceGroup.getParameterValue("hiddenService"))) {
                log.info((Object)Messages.getMessage("deployingws", serviceGroup.getServiceGroupName(), servicesURL.toString()));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), axisFault.getMessage()), (Throwable)axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            throw new DeploymentException(axisFault);
        }
    }

    public void deployFromUrl(Deployer deployer, URL servicesURL) throws DeploymentException {
        throw new DeploymentException("Not support for this operation - deployFromUrl(Deployer deployer, URL servicesURL)");
    }

    protected ArrayList<AxisService> populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            InputStream servicexmlStream;
            serviceGroup.setServiceGroupName(serviceName);
            ClassLoader serviceClassLoader = Utils.createClassLoader(servicesURL, null, this.axisConfig.getServiceClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
            String metainf = "meta-inf";
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            InputStream wsdlfilesStream = serviceClassLoader.getResourceAsStream("meta-inf/wsdl.list");
            if (wsdlfilesStream == null && (wsdlfilesStream = serviceClassLoader.getResourceAsStream("META-INF/wsdl.list")) != null) {
                metainf = "META-INF";
            }
            HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
            if (wsdlfilesStream != null) {
                Object line;
                ArchiveReader reader = new ArchiveReader();
                BufferedReader input = new BufferedReader(new InputStreamReader(wsdlfilesStream));
                while ((line = input.readLine()) != null) {
                    if (((String)(line = ((String)line).trim())).length() <= 0 || ((String)line).charAt(0) == '#') continue;
                    line = metainf + "/" + (String)line;
                    try {
                        List<AxisService> services = reader.getAxisServiceFromWsdl(serviceClassLoader.getResourceAsStream((String)line), serviceClassLoader, (String)line);
                        if (services == null) continue;
                        Iterator<AxisService> iterator = services.iterator();
                        while (iterator.hasNext()) {
                            AxisService service;
                            AxisService axisService = service = iterator.next();
                            servicesMap.put(axisService.getName(), axisService);
                        }
                    }
                    catch (Exception e) {
                        throw new DeploymentException(e);
                    }
                }
            }
            if ((servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml")) == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            } else {
                metainf = "META-INF";
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage("servicexmlnotfound", servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, this.configCtx);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if ("service".equals(elementName)) {
                AxisService axisService = null;
                Object wsdlLocation = "META-INF/service.wsdl";
                InputStream wsdlStream = serviceClassLoader.getResourceAsStream((String)wsdlLocation);
                URL wsdlURL = serviceClassLoader.getResource(metainf + "/service.wsdl");
                if (wsdlStream == null) {
                    wsdlLocation = "META-INF/" + serviceName + ".wsdl";
                    wsdlStream = serviceClassLoader.getResourceAsStream((String)wsdlLocation);
                    wsdlURL = serviceClassLoader.getResource((String)wsdlLocation);
                }
                if (wsdlStream != null) {
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, null, null);
                    File file = Utils.toFile(servicesURL);
                    if (file != null && file.exists()) {
                        wsdl2AxisServiceBuilder.setCustomWSDLResolver(new AARBasedWSDLLocator((String)wsdlLocation, file, wsdlStream));
                        wsdl2AxisServiceBuilder.setCustomResolver((URIResolver)new AARFileBasedURIResolver(file));
                    }
                    if (wsdlURL != null) {
                        wsdl2AxisServiceBuilder.setDocumentBaseUri(wsdlURL.toString());
                    }
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    axisService.setWsdlFound(true);
                    axisService.setCustomWsdl(true);
                    axisService.setName(serviceName);
                }
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                }
                axisService.setParent(serviceGroup);
                axisService.setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configCtx, axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            }
            if ("serviceGroup".equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, servicesMap, this.configCtx);
                ArrayList<AxisService> servicList = groupBuilder.populateServiceGroup(serviceGroup);
                for (AxisService axisService : servicList) {
                    Object wsdlLocation = "META-INF/service.wsdl";
                    InputStream wsdlStream = serviceClassLoader.getResourceAsStream((String)wsdlLocation);
                    URL wsdlURL = serviceClassLoader.getResource((String)wsdlLocation);
                    if (wsdlStream == null) {
                        wsdlLocation = "META-INF/" + serviceName + ".wsdl";
                        wsdlStream = serviceClassLoader.getResourceAsStream((String)wsdlLocation);
                        wsdlURL = serviceClassLoader.getResource((String)wsdlLocation);
                    }
                    if (wsdlStream == null) continue;
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, axisService);
                    File file = Utils.toFile(servicesURL);
                    if (file != null && file.exists()) {
                        wsdl2AxisServiceBuilder.setCustomWSDLResolver(new AARBasedWSDLLocator((String)wsdlLocation, file, wsdlStream));
                        wsdl2AxisServiceBuilder.setCustomResolver((URIResolver)new AARFileBasedURIResolver(file));
                    }
                    if (wsdlURL != null) {
                        wsdl2AxisServiceBuilder.setDocumentBaseUri(wsdlURL.toString());
                    }
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    axisService.setWsdlFound(true);
                    axisService.setCustomWsdl(true);
                    Iterator<AxisOperation> operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation operation = operations.next();
                        if (operation.getMessageReceiver() != null) continue;
                        operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), axisService));
                    }
                }
                return servicList;
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return null;
    }

    private MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/ns/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    @Override
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void setExtension(String extension) {
    }

    @Override
    public void undeploy(String fileName) throws DeploymentException {
        try {
            AxisServiceGroup serviceGroup;
            String serviceHierarchy = Utils.getServiceHierarchy((String)fileName, this.directory);
            fileName = Utils.getShortFileName((String)fileName);
            fileName = DeploymentEngine.getAxisServiceName((String)fileName);
            if (serviceHierarchy != null) {
                fileName = serviceHierarchy + (String)fileName;
            }
            if ((serviceGroup = this.axisConfig.removeServiceGroup((String)fileName)) != null) {
                Iterator<AxisService> services = serviceGroup.getServices();
                while (services.hasNext()) {
                    AxisService axisService = services.next();
                    ServiceLifeCycle serviceLifeCycle = axisService.getServiceLifeCycle();
                    if (serviceLifeCycle == null) continue;
                    serviceLifeCycle.shutDown(this.configCtx, axisService);
                }
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", (String)fileName));
            } else {
                this.axisConfig.removeFaultyService((String)fileName);
            }
            super.undeploy((String)fileName);
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService((String)fileName);
            throw new DeploymentException(axisFault);
        }
    }
}

