/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.json.moshi.MoshiXMLStreamReader;
import org.apache.axis2.json.moshi.rpc.JsonInOnlyRPCMessageReceiver;
import org.apache.axis2.json.moshi.rpc.JsonRpcMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONMessageHandler
extends AbstractHandler {
    Log log = LogFactory.getLog(JSONMessageHandler.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (axisOperation != null) {
            this.log.debug((Object)"Axis operation has been found from the MessageContext, proceeding with the JSON request");
            MessageReceiver messageReceiver = axisOperation.getMessageReceiver();
            if (messageReceiver instanceof JsonRpcMessageReceiver) return Handler.InvocationResponse.CONTINUE;
            if (messageReceiver instanceof JsonInOnlyRPCMessageReceiver) {
                return Handler.InvocationResponse.CONTINUE;
            }
            this.log.debug((Object)"JSON MessageReceiver found, proceeding with the JSON request");
            Object tempObj = msgContext.getProperty("isJsonStream");
            if (tempObj == null) return Handler.InvocationResponse.CONTINUE;
            boolean isJSON = Boolean.valueOf(tempObj.toString());
            Object o = msgContext.getProperty("MoshiXMLStreamReader");
            if (o != null) {
                MoshiXMLStreamReader moshiXMLStreamReader = (MoshiXMLStreamReader)o;
                QName elementQname = msgContext.getAxisOperation().getMessage("In").getElementQName();
                ArrayList schemas = msgContext.getAxisService().getSchema();
                moshiXMLStreamReader.initXmlStreamReader(elementQname, schemas, msgContext.getConfigurationContext());
                OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)moshiXMLStreamReader);
                OMElement omElement = stAXOMBuilder.getDocumentElement();
                msgContext.getEnvelope().getBody().addChild((OMNode)omElement);
                return Handler.InvocationResponse.CONTINUE;
            }
            this.log.error((Object)"MoshiXMLStreamReader is null");
            throw new AxisFault("MoshiXMLStreamReader should not be null");
        }
        String enableJSONOnly = (String)msgContext.getAxisService().getParameterValue("enableJSONOnly");
        if (enableJSONOnly != null && enableJSONOnly.equalsIgnoreCase("true")) {
            this.log.debug((Object)"On enableJSONOnly=true Axis operation is null on JSON request, message hasn't been dispatched to an operation, proceeding on JSON message name discovery and AxisOperation mapping");
            try {
                Object tempObj = msgContext.getProperty("isJsonStream");
                if (tempObj == null) return Handler.InvocationResponse.CONTINUE;
                boolean isJSON = Boolean.valueOf(tempObj.toString());
                Object o = msgContext.getProperty("MoshiXMLStreamReader");
                if (o == null) return Handler.InvocationResponse.CONTINUE;
                MoshiXMLStreamReader moshiXMLStreamReader = (MoshiXMLStreamReader)o;
                JsonReader jsonReader = moshiXMLStreamReader.getJsonReader();
                jsonReader.beginObject();
                String messageName = jsonReader.nextName();
                if (messageName == null) {
                    this.log.error((Object)("JSONMessageHandler can't find messageName: " + messageName));
                    throw new IOException("Bad Request");
                }
                this.log.debug((Object)("JSONMessageHandler found messageName: " + messageName));
                msgContext.setProperty("jsonMessageName", (Object)messageName);
                return Handler.InvocationResponse.CONTINUE;
            }
            catch (Exception e) {
                this.log.error((Object)("JSONMessageHandler error: " + e.getMessage()));
                return Handler.InvocationResponse.CONTINUE;
            }
        }
        this.log.debug((Object)"On enableJSONOnly=false Axis operation is null, ignore it");
        return Handler.InvocationResponse.CONTINUE;
    }
}

